package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtThumbVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCertificationVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;

@ApiSupport(order = 149002)
@Api(tags = "店铺管理")
@Slf4j
@Validated
@RestController
@RequestMapping("store/mgt")
public class GoblinStoreMgtController {
    @Autowired
    GoblinRedisUtils goblinRedisUtils;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "店铺管理:店铺列表")
    @GetMapping(value = {"list"})
    public ResponseDto<List<GoblinStoreMgtThumbVo>> thumbList() {
        ArrayList<GoblinStoreMgtThumbVo> storeMgtThumbList = ObjectUtil.getGoblinStoreMgtThumbVoArrayList();

        GoblinStoreInfoVo storeInfoVo = goblinRedisUtils.getStoreInfoVoByUid(CurrentUtil.getCurrentUid());
        if (null != storeInfoVo) {
            storeMgtThumbList.add(GoblinStoreMgtThumbVo.getNew().copy(storeInfoVo));
        }

        return ResponseDto.success(storeMgtThumbList);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "店铺管理:店铺信息")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID[64]"),
    })
    @GetMapping(value = {"info"})
    public ResponseDto<GoblinStoreMgtInfoVo> info(@NotBlank(message = "店铺ID不能为空") @RequestParam String storeId) {

        return ResponseDto.success(null);
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "店铺管理:店铺信息:修改")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID[64]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeName", value = "店铺名称[128]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "logoPic", value = "店铺LOGO[256]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "backgroundPic", value = "店铺背景图[256]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "introduce", value = "店铺介绍[500]"),
    })
    @GetMapping(value = {"info/edit"})
    public ResponseDto<GoblinStoreMgtInfoVo> infoEdit(@NotBlank(message = "店铺名称不能为空") @Size(max = 128) @RequestParam String storeName,
                                                      @NotBlank(message = "店铺LOGO不能为空") @Size(max = 256) @RequestParam String logoPic,
                                                      @NotBlank(message = "店铺背景图不能为空") @Size(max = 256) @RequestParam String backgroundPic,
                                                      @NotBlank(message = "店铺介绍不能为空") @Size(max = 500) @RequestParam String introduce,
                                                      @NotBlank(message = "店铺ID不能为空") @Size(max = 64) @RequestParam String storeId) {

        return ResponseDto.success(null);
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "店铺管理:认证信息")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID[64]"),
    })
    @GetMapping(value = {"info/cer"})
    public ResponseDto<GoblinStoreCertificationVo> certInfo(@NotBlank(message = "店铺ID不能为空") @Size(max = 64) @RequestParam String storeId) {

        return ResponseDto.success();
    }
}
