package com.liquidnet.service.account.util;

import com.liquidnet.service.api.sequence.feign.FeignSequenceClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

@Component
public class FinUtil {
    public static FinUtil finUtil;
    @Autowired
    private FeignSequenceClient sequenceClient;

    @PostConstruct
    public void init(){
        finUtil = this;
        finUtil.sequenceClient = this.sequenceClient;
    }

    private static Long nextID() {
        return finUtil.sequenceClient.nextId();
    }

    public static Long nextIncrId(String str) {
        return finUtil.sequenceClient.nextIncrId(str);
    }

    public static String getFinId() {
        return "10".concat(String.format("%015d", System.currentTimeMillis()));
    }

    public static String getTradeNo() {
        return "30".concat(String.format("%018d", nextID()));
    }

    public static String getTransNo() {
        return "40".concat(String.format("%015d", nextID()));
    }

    public static String getBillNo() {
        return "50".concat(String.format("%018d", nextID()));
    }

    public static String getAccNo(String accTypeCode, String accGroupId) {
        return accGroupId.concat(accTypeCode);
    }

    public static long modSeq(String shardingField, int mods) {
        if (null == shardingField || shardingField.trim().isEmpty()) {
            return -1;
        }
        return Long.parseLong(shardingField) % mods;
    }

}
