package com.liquidnet.service.reconciliation.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description:
 * @class: ReconConstants
 * @Package com.liquidnet.service.reconciliation.constant.ReconConstants
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/12/31 11:44 上午
 */
public class ReconConstants {
    public static final String CONTEXT = "recon";
    public static final String UPLOAD_LOCK_PREFIX = CONTEXT + "_upload_lock_";
    public static final String ACCOUNTING_LOCK_PREFIX = CONTEXT + "_accounting_lock_";
    public static final String FILE_PARSER_LOCK_PREFIX = CONTEXT + "_file_parser_lock_";
    /**
     * 银行渠道
     */
    public enum BankChannelEnum {
        /**
         *  CURRENCY_CLOUD
         */
        CURRENCY_CLOUD("CURRENCY_CLOUD"),

        /**
         * GLOBALCOLLECT
         */
        GC("GC"),

        CREDORAX("CREDORAX"),

        ADYEN("ADYEN"),

        /**
         * MoneyBook
         */
        MB("MB"),

        /**
         * CyberSource
         */
        CYBS("CYBS"),

        /**
         * WORLDPAY
         */
        RBS("RBS"),

        AE_DIRECT("AE_DIRECT"),

        SAFECHARGE("SAFECHARGE"),

        YANDEX("YANDEX"),

        EBANX("EBANX"),

        /**
         * 内部渠道 LIQUIDNET_WALLET 后续以wallet为基准跟CC对账
         */
        LIQUIDNET_WALLET("LIQUIDNET_WALLET"),

        /**
         * 内部渠道 LIQUIDNET_ADAM 后续以adam为基准跟CC对账
         */
        LIQUIDNET_ADAM("LIQUIDNET_ADAM")
        ;

        private String code;

        BankChannelEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        @Override
        public String toString() {
            return this.code;
        }

        public static List<String> toList() {
            BankChannelEnum[] ary = BankChannelEnum.values();
            List list = new ArrayList();
            for (int i = 0; i < ary.length; i++) {
                list.add(ary[i].getCode());
            }
            return list;
        }
    }

    /**
     * 对账状态枚举
     */
    public enum BatchStatusEnum {

        SUCCESS("对账操作成功"),

        FAIL("对账操作失败"),

        PROCESSING("对账处理中"),

        ERROR("银行返回错误信息"),

        NOBILL("银行没有订单信息");

        private String desc;

        BatchStatusEnum(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return desc;
        }

        public static BatchStatusEnum getEnum(String name) {
            BatchStatusEnum[] arry = BatchStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].name().equals(name)) {
                    return arry[i];
                }
            }
            return null;
        }

        @SuppressWarnings({ "rawtypes", "unchecked" })
        public static List toList() {
            MistakeHandleStatusEnum[] ary = MistakeHandleStatusEnum.values();
            List list = new ArrayList();
            for (int i = 0; i < ary.length; i++) {
                Map<String, String> map = new HashMap<String, String>();
                map.put("desc", ary[i].getDesc());
                map.put("name", ary[i].name());
                list.add(map);
            }
            return list;
        }
    }

    public enum DataParserTypeEnum {
        FORMAT_MT940("FORMAT_MT940"),
        FORMAT_CSV("FORMAT_CSV"),
        FORMAT_EXCEL("FORMAT_EXCEL");

        private String code;

        DataParserTypeEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        @Override
        public String toString() {
            return this.code;
        }
    }

    public enum LockTypeEnum {
        /**
         * 上传锁
         */
        UPLOAD_LOCK("UPLOAD_LOCK",UPLOAD_LOCK_PREFIX),
        /**
         * 对账锁
         */
        ACCOUNTING_LOCK("ACCOUNTING_LOCK",ACCOUNTING_LOCK_PREFIX),
        /**
         * 文件解析锁
         */
        FILE_PARSER_LOCK("FILE_PARSER_LOCK",FILE_PARSER_LOCK_PREFIX);

        private String code;

        private String keyPrefix;

        LockTypeEnum(String code,String keyPrefix) {
            this.code = code;
            this.keyPrefix = keyPrefix;
        }

        public String getCode() {
            return code;
        }

        @Override
        public String toString() {
            return this.code;
        }

        public String getKeyPrefix() {
            return keyPrefix;
        }

        public void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public static LockTypeEnum getEnum(String code) {
            LockTypeEnum[] arry = LockTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].name().equalsIgnoreCase(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public static String getKeyPrefixByCode(String code) {
            LockTypeEnum[] arry = LockTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].code.equalsIgnoreCase(code)) {
                    return arry[i].keyPrefix;
                }
            }
            return null;
        }
    }

    /**
     * 差错处理状态 .
     */
    public enum MistakeHandleStatusEnum {

        HANDLED("已处理"),

        NOHANDLE("未处理");

        private String desc;

        private MistakeHandleStatusEnum(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return desc;
        }

        public static MistakeHandleStatusEnum getEnum(String name) {
            MistakeHandleStatusEnum[] arry = MistakeHandleStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].name().equals(name)) {
                    return arry[i];
                }
            }
            return null;
        }

        @SuppressWarnings({ "rawtypes", "unchecked" })
        public static List toList() {
            MistakeHandleStatusEnum[] ary = MistakeHandleStatusEnum.values();
            List list = new ArrayList();
            for (int i = 0; i < ary.length; i++) {
                Map<String, String> map = new HashMap<String, String>();
                map.put("desc", ary[i].getDesc());
                map.put("name", ary[i].name());
                list.add(map);
            }
            return list;
        }

    }

    /**
     * 对账差错类型枚举 .
     */
    public enum MistakeTypeEnum {

        BANK_MISS("银行漏单"), // 银行不存在该订单
        PLATFORM_MISS("平台漏单"), // 平台不存在该订单
        PLATFORM_SHORT_STATUS_MISMATCH("平台短款，状态不符"), // 银行支付成功，平台支付不成功（比较常见）
        PLATFORM_SHORT_CASH_MISMATCH("平台短款，金额不符"), // 平台需支付金额比银行实际支付金额少（基本不会出现）
        PLATFORM_OVER_CASH_MISMATCH("平台长款,金额不符"), // 银行实际支付金额比平台需支付金额少
        PLATFORM_OVER_STATUS_MISMATCH("平台长款,状态不符"), // 平台支付成功，银行支付不成功（基本不会出现）
        FEE_MISMATCH("手续费不匹配");

        /** 描述 */
        private String desc;

        private MistakeTypeEnum(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, Map<String, Object>> toMap() {
            MistakeTypeEnum[] ary = MistakeTypeEnum.values();
            Map<String, Map<String, Object>> enumMap = new HashMap<String, Map<String, Object>>();
            for (int num = 0; num < ary.length; num++) {
                Map<String, Object> map = new HashMap<String, Object>();
                String key = ary[num].name();
                map.put("desc", ary[num].getDesc());
                map.put("name", ary[num].name());
                enumMap.put(key, map);
            }
            return enumMap;
        }

        @SuppressWarnings({ "rawtypes", "unchecked" })
        public static List toList() {
            MistakeTypeEnum[] ary = MistakeTypeEnum.values();
            List list = new ArrayList();
            for (int i = 0; i < ary.length; i++) {
                Map<String, String> map = new HashMap<String, String>();
                map.put("desc", ary[i].getDesc());
                map.put("name", ary[i].name());
                list.add(map);
            }
            return list;
        }

        public static MistakeTypeEnum getEnum(String name) {
            MistakeTypeEnum[] arry = MistakeTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].name().equalsIgnoreCase(name)) {
                    return arry[i];
                }
            }
            return null;
        }

        /**
         * 取枚举的json字符串
         *
         * @return
         */
        public static String getJsonStr() {
            MistakeTypeEnum[] enums = MistakeTypeEnum.values();
            StringBuffer jsonStr = new StringBuffer("[");
            for (MistakeTypeEnum senum : enums) {
                if (!"[".equals(jsonStr.toString())) {
                    jsonStr.append(",");
                }
                jsonStr.append("{id:'").append(senum).append("',desc:'").append(senum.getDesc()).append("'}");
            }
            jsonStr.append("]");
            return jsonStr.toString();
        }
    }

    /**
     * 公共枚举. 针对只有“是”，“否”两种状态
     */
    public enum PublicEnum {

        YES("是"),

        NO("否");

        /** 描述 */
        private String desc;

        private PublicEnum(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, Map<String, Object>> toMap() {
            PublicEnum[] ary = PublicEnum.values();
            Map<String, Map<String, Object>> enumMap = new HashMap<String, Map<String, Object>>();
            for (int num = 0; num < ary.length; num++) {
                Map<String, Object> map = new HashMap<String, Object>();
                String key = ary[num].name();
                map.put("desc", ary[num].getDesc());
                enumMap.put(key, map);
            }
            return enumMap;
        }

        @SuppressWarnings({ "rawtypes", "unchecked" })
        public static List toList() {
            PublicEnum[] ary = PublicEnum.values();
            List list = new ArrayList();
            for (int i = 0; i < ary.length; i++) {
                Map<String, String> map = new HashMap<String, String>();
                map.put("desc", ary[i].getDesc());
                list.add(map);
            }
            return list;
        }

        public static PublicEnum getEnum(String name) {
            PublicEnum[] arry = PublicEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].name().equalsIgnoreCase(name)) {
                    return arry[i];
                }
            }
            return null;
        }

        /**
         * 取枚举的json字符串
         *
         * @return
         */
        public static String getJsonStr() {
            PublicEnum[] enums = PublicEnum.values();
            StringBuffer jsonStr = new StringBuffer("[");
            for (PublicEnum senum : enums) {
                if (!"[".equals(jsonStr.toString())) {
                    jsonStr.append(",");
                }
                jsonStr.append("{id:'").append(senum).append("',desc:'").append(senum.getDesc()).append("'}");
            }
            jsonStr.append("]");
            return jsonStr.toString();
        }

    }

    /**
     * 交易状态
     */
    public enum TransStatusEnum {

        /**
         * 交易成功
         */
        SUCCESS("交易成功"),

        /**
         * 交易失败
         */
        FAILED("交易失败"),

        /**
         * 交易处理中
         */
        PROCESSING("交易处理中"),

        /**
         * 交易处理中
         */
        UNKNOWN("未知状态");

        /** 描述 */
        private String desc;

        private TransStatusEnum(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public static Map<String, Map<String, Object>> toMap() {
            TransStatusEnum[] ary = TransStatusEnum.values();
            Map<String, Map<String, Object>> enumMap = new HashMap<String, Map<String, Object>>();
            for (int num = 0; num < ary.length; num++) {
                Map<String, Object> map = new HashMap<String, Object>();
                String key = ary[num].name();
                map.put("desc", ary[num].getDesc());
                enumMap.put(key, map);
            }
            return enumMap;
        }

        @SuppressWarnings({ "rawtypes", "unchecked" })
        public static List toList() {
            TransStatusEnum[] ary = TransStatusEnum.values();
            List list = new ArrayList();
            for (int i = 0; i < ary.length; i++) {
                Map<String, String> map = new HashMap<String, String>();
                map.put("desc", ary[i].getDesc());
                map.put("name", ary[i].name());
                list.add(map);
            }
            return list;
        }

        public static TransStatusEnum getEnum(String name) {
            TransStatusEnum[] arry = TransStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].name().equalsIgnoreCase(name)) {
                    return arry[i];
                }
            }
            return null;
        }

        /**
         * 取枚举的json字符串
         *
         * @return
         */
        public static String getJsonStr() {
            TransStatusEnum[] enums = TransStatusEnum.values();
            StringBuffer jsonStr = new StringBuffer("[");
            for (TransStatusEnum senum : enums) {
                if (!"[".equals(jsonStr.toString())) {
                    jsonStr.append(",");
                }
                jsonStr.append("{id:'").append(senum).append("',desc:'").append(senum.getDesc()).append("'}");
            }
            jsonStr.append("]");
            return jsonStr.toString();
        }
    }

    public enum TransTypeEnum {
        /**
         * 充值
         */
        RECHARGE("RECHARGE"),
        /**
         * 下发
         */
        PAYOUT("PAYOUT"),
        /**
         * 换汇
         */
        EXCHANGE("EXCHANGE"),
        /**
         * 支付
         */
        PAY("PAY"),
        /**
         * 退款
         */
        REFUND("REFUND"),
        /**
         * void退款  (capture操作前退款)
         */
        REFUND_VOID("REFUND_VOID"),
        /**
         * 退款撤销
         */
        REFUND_REVERSED("REFUND_REVERSED"),
        /**
         * 拒付
         */
        CHARGEBACK("CHARGEBACK"),
        /**
         * 拒付撤销
         */
        CHARGEBACK_REVERSED("CHARGEBACK_REVERSED"),
        /**
         * 转账
         */
        TRANSFER("TRANSFER");



        private String code;

        private TransTypeEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        @Override
        public String toString() {
            return this.code;
        }
    }
}
