package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerGoblinShopCartReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class ConsumerGoblinShopCartStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerGoblinShopCartReceiver consumerGoblinShopCartReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlShopCar(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.GOBLIN_SHOP_CART;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinShopCartReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

//    /**
//     * 购物车
//     * @return Subscription
//     */
//    private Subscription receiveSqlShopCart(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.GoblinQueue.GOBLIN_SHOP_CART.getGroup(), getConsumerName(MQConst.GoblinQueue.GOBLIN_SHOP_CART.name() + t)),
//                StreamOffset.create(MQConst.GoblinQueue.GOBLIN_SHOP_CART.getKey(), ReadOffset.lastConsumed()), consumerGoblinShopCartReceiver);
//    }
//
//    /* -------------------------------------------------------- ｜  */
//
//    @Bean
//    public Subscription subscriptionSqlShopCart0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlShopCart(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
////    @Bean
////    public Subscription subscriptionSqlShopCart1(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlShopCart(listenerContainer, 1);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionSqlShopCart2(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlShopCart(listenerContainer, 2);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionSqlShopCart3(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlShopCart(listenerContainer, 3);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionSqlShopCart4(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlShopCart(listenerContainer, 4);
////        listenerContainer.start();
////        return subscription;
////    }

    /* -------------------------------------------------------- ｜  */

}
