package com.liquidnet.service.sweet.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class IntegralActivityPrizeApiVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -303399210433737206L;

    @ApiModelProperty(value = "奖品id")
    private String prizeId;

    @ApiModelProperty(value = "关联活动id")
    private String integralActivityId;

    @ApiModelProperty(value = "抽奖id")
    private String drawId;

    @ApiModelProperty(value = "奖品名称")
    private String prizeTitle;

    @ApiModelProperty(value = "奖品描述")
    private String prizeDescribe;

    @ApiModelProperty(value = "初始展示奖品图片")
    private String prizeImgInit;

    @ApiModelProperty(value = "中奖选中奖品图片")
    private String prizeImgSelect;

    @ApiModelProperty(value = "奖品类型 1积分 2优惠券 3实物 4登登登VIP")
    private Integer prizeType;

    @ApiModelProperty(value = "单次奖励数量如积分 中奖给多少物")
    private Integer prizeTypeNum;

    private static final IntegralActivityPrizeApiVo obj = new IntegralActivityPrizeApiVo();
    public static IntegralActivityPrizeApiVo getNew() {
        try {
            return (IntegralActivityPrizeApiVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new IntegralActivityPrizeApiVo();
        }
    }

    public IntegralActivityPrizeApiVo copy(IntegralActivityPrizeVo source) {
        if (null == this) return this;
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setPrizeId(source.getPrizeId());
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setPrizeTitle(source.getPrizeTitle());
        this.setPrizeDescribe(source.getPrizeDescribe());
        this.setPrizeImgInit(source.getPrizeImgInit());
        this.setPrizeImgSelect(source.getPrizeImgSelect());
        this.setPrizeType(source.getPrizeType());
        this.setPrizeTypeNum(source.getPrizeTypeNum());
        return this;
    }

}
