package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxySeriesInfoBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 15:03
 */
@Data
public class GalaxySeriesInfoBo implements Serializable,Cloneable {
    /**
     * 本地系列唯一标识id
     */
    private String skuId;
    /**
     * 本地系列唯一名称(前缀+skuid)
     */
    private String seriesName;
    /**
     * 区块链上系列ID(系列声明后获取,NFT发行购买用到)
     */
    private String seriesId;
    /**
     * 系列发行总量
     */
    private Long totalCount;
    /**
     * 系列已发行个数
     */
    private Long crtCount;
    /**
     * nft素材原始地址
     */
    private String originalNftUrl;
    /**
     * nft显示素材原始地址
     */
    private String originalDisplayUrl;
    /**
     * 系列声明任务ID
     */
    private String seriesClaimTaskId;
    /**
     * 系列声明状态
     */
    private String seriesClaimStatus;
    /**
     * 系列声明时间
     */
    private String seriesClaimTime;

    //======================================
    //=============以下都为购买信息=============
    //======================================
    /**
     * 作者名，中文+英文(数字或符号为非法输入) 不超过30个字符
     */
    private String author;

    /**
     * nft名字(sku名称)，中英文数字均可，不超过256个字符
     */
    private String nftName;

    /**
     * nft素材地址
     */
    private String nftUrl;

    /**
     * 预览图url，不超过1024个字符。(至信链浏览器展示预览图尺寸为290*290，请上传比例为1:1的图片)
     */
    private String displayUrl;

    /**
     * nft简介，500个字符以内
     */
    private String nftDesc;

    /**
     * 标签，【文创】，游戏，动漫，30个字符以内
     * 非必填
     */
    private String nftFlag;

    /**
     * 可售状态下有意义，表示售卖多少积分
     */
    private BigDecimal sellCount;

    /**
     * 系列显示封面
     */
    private String coverUrl;

    /**
     * 系列描述信息，不超过500个字符
     */
    private String seriesDesc;

    /**
     * 系列声明中nftHash
     */
    private String nftHash;


    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxySeriesInfoBo obj = new GalaxySeriesInfoBo();

    public static GalaxySeriesInfoBo getNew() {
        try {
            return (GalaxySeriesInfoBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxySeriesInfoBo();
        }
    }
}
