package com.liquidnet.service.merchant.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.merchant.entity.MerchantFieldApplies;
import com.liquidnet.service.merchant.entity.MerchantFields;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

@ApiModel(value = "MerchantFieldsVo", description = "场地")
@Data
public class MerchantFieldsVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 2531062739435013044L;

    @ApiModelProperty(position = 11, value = "场地ID")
    private String fieldId;

    @ApiModelProperty(position = 12, value = "上线状态 0下线 1下线")
    private Integer isOnline;
    @ApiModelProperty(position = 13, value = "认领状态 0未认领 1已认领 2认领中")
    private Integer claimStatus;
    @ApiModelProperty(position = 14, value = "场地所有者账号")
    private String uid;
    @ApiModelProperty(position = 15, value = "审核演出开关 0不审 1审核")
    private Integer isCheck;

    @ApiModelProperty(position = 16, value = "场地名称[30]")
    private String name;
    @ApiModelProperty(position = 17, value = "logo图")
    private String logo;
    @ApiModelProperty(position = 18, value = "背景图")
    private String background;
    @ApiModelProperty(position = 19, value = "介绍[1000]")
    private String description;
    @ApiModelProperty(position = 20, value = "建立日期[YYYY-MM-DD]")
    private LocalDate builtDate;

    @ApiModelProperty(position = 21, value = "省id")
    private String provinceId;
    @ApiModelProperty(position = 22, value = "省名称")
    private String provinceName;
    @ApiModelProperty(position = 23, value = "城市id")
    private String cityId;
    @ApiModelProperty(position = 24, value = "城市名称")
    private String cityName;
    @ApiModelProperty(position = 25, value = "县id")
    private String districtId;
    @ApiModelProperty(position = 26, value = "县名称")
    private String districtName;
    @ApiModelProperty(position = 27, value = "详细地址[100]")
    private String address;
    @ApiModelProperty(position = 28, value = "经度")
    private String longitude;
    @ApiModelProperty(position = 29, value = "纬度")
    private String latitude;

    @ApiModelProperty(position = 30, value = "联系人姓名")
    private String contactName;
    @ApiModelProperty(position = 31, value = "联系人邮箱")
    private String contactEmail;

    @ApiModelProperty(position = 32, value = "企业ID")
    private String companyId;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;


    private static final MerchantFieldsVo obj = new MerchantFieldsVo();

    public static MerchantFieldsVo getNew() {
        try {
            return (MerchantFieldsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MerchantFieldsVo();
    }

    public MerchantFieldsVo copy(MerchantFields source) {
        if (null == source) return this;

        this.setFieldId(source.getFieldId());
        this.setIsOnline(source.getIsOnline());
        this.setClaimStatus(source.getClaimStatus());
        this.setUid(source.getUid());
        this.setIsCheck(source.getIsCheck());

        this.setName(source.getName());
        this.setLogo(source.getLogo());
        this.setBackground(source.getBackground());
        this.setDescription(source.getDescription());
        this.setBuiltDate(source.getBuiltDate());

        this.setProvinceId(source.getProvinceId());
        this.setProvinceName(source.getProvinceName());
        this.setCityId(source.getCityId());
        this.setCityName(source.getCityName());
        this.setDistrictId(source.getDistrictId());
        this.setDistrictName(source.getDistrictName());
        this.setAddress(source.getAddress());
        this.setLongitude(source.getLongitude());
        this.setLatitude(source.getLatitude());

        this.setContactName(source.getContactName());
        this.setContactEmail(source.getContactEmail());

        this.setCompanyId(source.getCompanyId());

        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());

        return this;
    }

}
