package com.liquidnet.client.admin.web.controller.zhengzai.merchant;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantSponsorsAdminService;
import com.liquidnet.service.merchant.dto.param.admin.MerchantSponsorEditParam;
import com.liquidnet.service.merchant.dto.param.admin.MerchantSponsorListParam;
import com.liquidnet.service.merchant.dto.vo.MerchantSponsorsVo;
import com.liquidnet.service.merchant.entity.MerchantSponsors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "主办管理")
@Controller
@RequestMapping("merchant/sponsor")
public class MerchantSponsorsController extends BaseController {

    private final String prefix = "zhengzai/kylin/sponsor";

    @Autowired
    IMerchantSponsorsAdminService merchantSponsorsAdminService;


    @RequiresPermissions("merchant:sponsor:view")
    @GetMapping()
    public String list() {
        return prefix + "/list";
    }


    @Log(title = "主办列表", businessType = BusinessType.LIST)
    @RequiresPermissions("merchant:sponsor:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(MerchantSponsorListParam param) {
        startPage();
        return getDataTable(merchantSponsorsAdminService.list(
                Wrappers.lambdaQuery(MerchantSponsors.class)
                        .eq(param.getSponsorId().length() > 0, MerchantSponsors::getSponsorId, param.getSponsorId())
                        .eq(param.getIsOnline() >= 0, MerchantSponsors::getIsOnline, param.getIsOnline())
                        .select(
                                MerchantSponsors::getSponsorId, MerchantSponsors::getIsOnline, MerchantSponsors::getUid,
                                MerchantSponsors::getName, MerchantSponsors::getLogo,
                                MerchantSponsors::getCreatedAt
                        )
        ));
    }

    @Log(title = "主办详情", businessType = BusinessType.DETAIL)
    @RequiresPermissions("merchant:sponsor:detail")
    @GetMapping(value = "/details/{sponsorId}")
    public String detail(@PathVariable("sponsorId") String sponsorId, ModelMap mmap) {

        LambdaQueryWrapper<MerchantSponsors> sponsorsLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantSponsors.class);
        sponsorsLambdaQueryWrapper.eq(MerchantSponsors::getSponsorId, sponsorId);
        MerchantSponsors sponsors = merchantSponsorsAdminService.getOne(sponsorsLambdaQueryWrapper);

        MerchantSponsorsVo sponsorsVo = MerchantSponsorsVo.getNew();
        sponsorsVo.copy(sponsors);

        mmap.put("sponsorInfo", sponsorsVo);

        return prefix + "/detail";
    }

    @ApiOperation(value = "主办编辑")
    @Log(title = "主办编辑", businessType = BusinessType.UPDATE)
    @RequiresPermissions("merchant:sponsor:edit")
    @PostMapping("edit")
    @ResponseBody
    public AjaxResult edit(@RequestBody @Validated MerchantSponsorEditParam parameter) {
        return toAjax(merchantSponsorsAdminService.sponsorEdit(parameter));
    }
}
