package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class GoblinListDetailsVo implements Serializable, Cloneable {
    @ApiModelProperty(value = "名单id")
    private String listId;
    @ApiModelProperty(value = "用户id")
    private String uid;
    @ApiModelProperty(value = "优先购名称")
    private String name;
    @ApiModelProperty(value = "优先购类型[0-会员|1-指定用户]")
    private Integer whiteType;
    @ApiModelProperty(value = "优先购文件地址")
    private String whiteUrl;

    @ApiModelProperty(value = "标签[0-提前购买|1-分段购买]")
    private Integer tagType;
    @ApiModelProperty(value = "开始时间")
    private String timeStart;
    @ApiModelProperty(value = "结束时间")
    private String timeEnd;

    @ApiModelProperty(value = "黑名单文件地址")
    private String blackUrl;
    @ApiModelProperty(value = "商品数据")
    private List<GoblinListDetailsItemVo> itemVo;
    @ApiModelProperty(value = "创建时间")
    private String createdAt;

    @ApiModelProperty(value = "白名单文件名称")
    private String whiteName;
    @ApiModelProperty(value = "黑名单文件名称")
    private String blackName;

    private static final GoblinListDetailsVo obj = new GoblinListDetailsVo();

    public static GoblinListDetailsVo getNew() {
        try {
            return (GoblinListDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinListDetailsVo();
    }
}
