package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@ApiModel(value = "SellDataOneVO", description = "销量数据")
@Data
public class CommissionVO implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "title:演出名,performanceId:演出id，commiss:佣金,status:(1、待入账（项目未结束）2、演出已结束（可结算）3、已结算（已完成）)")
    private List<Map> list;
    @ApiModelProperty(value = "可结算")
    private BigDecimal keJieSuan;
    @ApiModelProperty(value = "待入账")
    private BigDecimal daiRuZhang;
    @ApiModelProperty(value = "总营收")
    private BigDecimal zongYingShou;
    private static final CommissionVO obj = new CommissionVO();

    public BigDecimal getKeJieSuan() {
        return keJieSuan==null?BigDecimal.ZERO:keJieSuan;
    }

    public BigDecimal getDaiRuZhang() {
        return daiRuZhang==null?BigDecimal.ZERO:daiRuZhang;
    }

    public BigDecimal getZongYingShou() {
        return zongYingShou==null?BigDecimal.ZERO:zongYingShou;
    }

    public static CommissionVO getNew() {
        try {
            return (CommissionVO) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CommissionVO();
        }
    }




}
