package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 手环订单详情表实体类
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinBraceletOrderEntities implements Serializable {

    /**
     * 主键ID
     */
    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单详情ID
     */
    private String orderEntitiesId;

    /**
     * 订单详情关联ID
     */
    private String orderId;

    /**
     * 商品类型：1：手环 2：充值面值
     */
    private Integer goodsType;

    /**
     * 商品ID wristband_id:手环ID amount_id：充值金额ID
     */
    private String goodsId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品金额
     */
    private BigDecimal goodsPrice;

    /**
     * 订单状态:
     * 0 待付款
     * 1 已付款
     * 2 已关闭
     * 3 正在退款
     * 4 已退款
     * 5 待关闭
     * 6 部分退款
     */
    private Integer status;

    /**
     * 支付状态:
     * 0 未支付
     * 1 已支付
     * 2 支付失败
     */
    private Integer payStatus;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;
}
