package com.liquidnet.service.candy.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;

import com.liquidnet.service.candy.dto.CouponDao;
import com.liquidnet.service.candy.entity.CandyUserCoupon;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 用户券信息 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
public interface CandyUserCouponMapper extends BaseMapper<CandyUserCoupon> {

    /**
     * <p>
     * 查取指定UID用户的券列表
     * </p>
     * 限定用户券状态[state <> 2-无效]
     *
     * @param uid 用户UID
     * @return List<CandyUserCouponBasicDto>
     */
    List<CandyUserCouponBasicDto> selectMultiForUserCouponBasicDto(@Param("uid") String uid);



    /**
     * 查询优惠卷信息
     * @author zjp
     * @return: java.util.List<com.liquidnet.service.stone.dto.CouponDao>
     * @date 2024/3/13 13:56
     */
    List<CouponDao> couponReturn();

    /**
     * 查询羊毛卷信息
     */
    List<CouponDao> WoolRoll();
}
