package com.liquidnet.service.platform.utils;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.io.*;

@Slf4j
@Component
public class JSONUtils {
    /**
     * 读取json文件
     *
     * @param fileName json文件路径
     * @return
     */
    public static String readJsonFile(String fileName) {
        //fileName = JSONUtils.class.getClassLoader().getResource("city.json").getPath();
        File jsonFile = new File(fileName);
        String jsonStr = "";
        log.info("————开始读取" + jsonFile.getPath() + "文件————");
        try {
            FileReader fileReader = new FileReader(jsonFile);
            Reader reader = new InputStreamReader(new FileInputStream(jsonFile), "utf-8");
            int ch = 0;
            StringBuffer sb = new StringBuffer();
            while ((ch = reader.read()) != -1) {
                sb.append((char) ch);
            }

            fileReader.close();
            reader.close();
            jsonStr = sb.toString();
            log.info("————读取" + jsonFile.getPath() + "文件结束!————");
            return jsonStr;
        } catch (Exception e) {
            log.info("————读取" + jsonFile.getPath() + "文件出现异常，读取失败!————");
            e.printStackTrace();
            return null;
        }
    }
}


