package com.liquidnet.service.dragon.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonOrdersDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataUtils {
    @Autowired
    private RedisUtil redisUtil;

    private long keyExpireTime = 3600*24*7;

    public void createPayOrder(String code, DragonOrdersDto ordersDto) {
        if (!redisUtil.hasKey(DragonConstant.REDIS_KET_PAY_CODE + code)) {
            redisUtil.set(DragonConstant.REDIS_KET_PAY_CODE + code, ordersDto,keyExpireTime);
        }
    }

    public DragonOrdersDto getPayOrderByCode(String code) {
        if (redisUtil.hasKey(DragonConstant.REDIS_KET_PAY_CODE + code)) {
            return (DragonOrdersDto) redisUtil.get(DragonConstant.REDIS_KET_PAY_CODE + code);
        }
        return null;
    }

    public void updateOrderStatus(String code, DragonOrdersDto dragonOrdersDto) {
        redisUtil.set(DragonConstant.REDIS_KET_PAY_CODE + code, dragonOrdersDto,keyExpireTime);
    }

    public void setRefundNotifyUrl(String code, String notifyUrl) {
        redisUtil.set(DragonConstant.REFUND_REDIS_KET + code, notifyUrl,keyExpireTime);
    }

    public String getRefundNotifyUrl(String code) {
        return (String) redisUtil.get(DragonConstant.REFUND_REDIS_KET + code);
    }
}
