package com.liquidnet.service.candy.dto;

import com.liquidnet.service.candy.entity.CandyCouponRule;
import lombok.Data;

import java.io.Serializable;

@Data
public class CandyCouponRuleDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -3727352492315559906L;

    private String cruleId;
    private String couponId;
    private Integer useScope;
    private String busiName;
    private String busiId;
    //private Integer state;
    //private String comment;

    private static final CandyCouponRuleDto obj = new CandyCouponRuleDto();

    public static CandyCouponRuleDto getNew() {
        try {
            return (CandyCouponRuleDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyCouponRuleDto();
        }
    }

    public CandyCouponRuleDto copy(CandyCouponRule source) {
        if (null == source) return this;
        this.setCruleId(source.getCruleId());
        this.setCouponId(source.getCouponId());
        this.setUseScope(source.getUseScope());
        this.setBusiName(source.getBusiName());
        this.setBusiId(source.getBusiId());
        return this;
    }
}
