package com.liquidnet.common.exception;

import com.liquidnet.common.exception.constant.ServiceErrorCode;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: liquid global Exception
 * @class: LiquidnetServiceException
 * @Package com.liquidnet.common.exception
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/21 10:37
 */
public class LiquidnetServiceException extends RuntimeException{
    private ServiceErrorCode errorCode;
    private String message;
    private String url;
    public LiquidnetServiceException(){}

    public LiquidnetServiceException(ServiceErrorCode errorCode){
        this.errorCode = errorCode;
    }

    public LiquidnetServiceException(String message) {
        super(message);
        this.message = message;
    }

    public LiquidnetServiceException(ServiceErrorCode errorCode, String message){
        super(message);
        this.errorCode = errorCode;
        this.message = message;
    }
    public ServiceErrorCode errorCode() {
        return errorCode;
    }

    public String getMessage() {
        return message;
    }

    public LiquidnetServiceException(ServiceErrorCode errorCode, String message, String url){
        super(message);
        this.errorCode = errorCode;
        this.message = message;
        this.url = url;
    }

    public String getUrl() {
        return url;
    }
}
