package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsActionParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsEditSkuParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsFilterParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.manage.IGoblinstoreMgtGoodsService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class GoblinStoreMgtGoodsServiceImpl implements IGoblinstoreMgtGoodsService {
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;

    @Override
    public PagedResult<GoblinStoreMgtGoodsListVo> goodsList(GoblinStoreMgtGoodsFilterParam filterParam) {
        return goblinMongoUtils.getGoodsInfoVo(filterParam);
    }

    @Override
    public void goodsAdd(GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();

        GoblinGoodsInfoVo vo = storeMgtGoodsAddParam.initGoodsInfoVo();
        vo.setCreatedBy(uid);
        vo.setCreatedAt(now);

        ArrayList<GoblinGoodsSpecVo> goodsSpecVoList = ObjectUtil.getGoblinGoodsSpecVoArrayList();
        List<GoblinGoodsSkuInfoVo> goodsSkuInfoVoList = ObjectUtil.getGoblinGoodsSkuInfoVoArrayList();
        storeMgtGoodsAddParam.initGoodsSkuInfoVo(vo, goodsSkuInfoVoList, goodsSpecVoList);

        {// 标签处理
            List<String> goodsTagIdList = storeMgtGoodsAddParam.getTagList();
            List<String> goodsExtagIdList = storeMgtGoodsAddParam.getExtagList();
            boolean goodsTagIsEmpty = CollectionUtils.isEmpty(goodsTagIdList);
            boolean goodsExtagIsEmpty = CollectionUtils.isEmpty(goodsExtagIdList);

            ArrayList<String> tagIdList = CollectionUtil.arrayListString();
            tagIdList.addAll(goodsTagIdList);
            tagIdList.addAll(goodsExtagIdList);
            if (!CollectionUtils.isEmpty(tagIdList)) {
                List<GoblinSelfTagVo> selfTagVoList = goblinMongoUtils.getSelfTagVos(tagIdList);
                if (!goodsTagIsEmpty) {
                    List<GoblinGoodsTagVo> goodsTagVoList = ObjectUtil.getGoblinGoodsTagVoArrayList();
                    for (int i = 0; i < tagIdList.size(); i++) {
                        String tagId = tagIdList.get(i);
                        for (GoblinSelfTagVo r : selfTagVoList) {
                            if (r.getTagId().equals(tagId)) {
                                goodsTagVoList.add(GoblinGoodsTagVo.getNew().copy(r).setSort(i));
                            }
                        }
                    }
                    vo.setTagVoList(goodsTagVoList);
                }
                if (!goodsExtagIsEmpty) {
                    List<GoblinGoodsExtagVo> goodsExtagVoList = ObjectUtil.getGoblinGoodsExtagVoArrayList();
                    for (int i = 0; i < tagIdList.size(); i++) {
                        String tagId = tagIdList.get(i);
                        for (GoblinSelfTagVo r : selfTagVoList) {
                            if (r.getTagId().equals(tagId)) {
                                goodsExtagVoList.add(GoblinGoodsExtagVo.getNew().copy(r).setSort(i));
                            }
                        }
                    }
                    vo.setExtagVoList(goodsExtagVoList);
                }
            }
        }

        // 服务保障处理
        vo.setServiceSupportVoList(goblinMongoUtils.getServiceSupportVos(storeMgtGoodsAddParam.getSsidList()));

        goblinMongoUtils.setGoodsInfoVo(vo);
        goblinMongoUtils.setGoodsSkuInfoVos(goodsSkuInfoVoList);
    }

    @Override
    public GoblinStoreMgtGoodsInfoVo goodsInfo(String storeId, String spuId) {
        GoblinStoreMgtGoodsInfoVo vo = GoblinStoreMgtGoodsInfoVo.getNew();
        GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getMgtGoodsInfoVo(spuId);
        if (null != goodsInfoVo) {
            vo.setGoodsInfoVo(goodsInfoVo);
            List<String> skuIdList = goodsInfoVo.getSkuIdList();
            if (!CollectionUtils.isEmpty(skuIdList)) {
                List<GoblinGoodsSkuInfoVo> goodsSkuInfoVoList = ObjectUtil.getGoblinGoodsSkuInfoVoArrayList();
                skuIdList.forEach(skuId -> goodsSkuInfoVoList.add(goblinRedisUtils.getMgtGoodsSkuInfoVo(skuId)));
                vo.setGoodsSkuInfoVoList(goodsSkuInfoVoList);
            }
        }
        return vo;
    }

    @Override
    public boolean goodsEditSpu(GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam) {
        GoblinGoodsInfoVo editGoodsSkuInfoVo = storeMgtGoodsAddParam.initEditGoodsInfoVo();
        if (goblinMongoUtils.updateGoodsInfoVo(editGoodsSkuInfoVo)) {
            GoblinGoodsSkuInfoVo updateSkuInfoVo = GoblinGoodsSkuInfoVo.getNew();
            updateSkuInfoVo.setSpuId(editGoodsSkuInfoVo.getSpuId());
            updateSkuInfoVo.setSkuNo(editGoodsSkuInfoVo.getSpuNo());
            updateSkuInfoVo.setName(editGoodsSkuInfoVo.getName());
            updateSkuInfoVo.setSubtitle(editGoodsSkuInfoVo.getSubtitle());
            updateSkuInfoVo.setVirtualFlg(editGoodsSkuInfoVo.getVirtualFlg());
            updateSkuInfoVo.setLogisticsTemplate(editGoodsSkuInfoVo.getLogisticsTemplate());

            goblinMongoUtils.updateGoodsSkuInfoVoBySpuId(updateSkuInfoVo);
            // TODO: 2022/1/5 zhanggb redis+sql

            return true;
        }
        return false;
    }

    @Override
    public boolean goodsEditSku(GoblinStoreMgtGoodsEditSkuParam storeMgtGoodsEditSkuParam, GoblinGoodsInfoVo goodsInfoVo) {
        GoblinGoodsSkuInfoVo editGoodsSkuInfoVo = storeMgtGoodsEditSkuParam.initEditGoodsSkuInfoVo();
        if (goblinMongoUtils.updateGoodsSkuInfoVo(editGoodsSkuInfoVo)) {
            if (!CollectionUtils.isEmpty(storeMgtGoodsEditSkuParam.getSkuSpecList())) {// 更改了规格，需要同步SPU里的规格信息
                goblinMongoUtils.updateGoodsInfoVo(goodsInfoVo);
            }
            // TODO: 2022/1/5 zhanggb redis+sql

            return true;
        }
        return false;
    }

    @Override
    public void goodsEditSkuAdd(GoblinStoreMgtGoodsEditSkuParam storeMgtGoodsEditSkuParam, GoblinGoodsInfoVo goodsInfoVo) {
        String spuId = storeMgtGoodsEditSkuParam.getSpuId();
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();

        GoblinGoodsSkuInfoVo addGoodsSkuInfoVo = storeMgtGoodsEditSkuParam.initEditAddGoodsSkuInfoVo();
        addGoodsSkuInfoVo.setSkuId(spuId.concat(StringUtils.right(String.valueOf(System.nanoTime()), 5)));
        addGoodsSkuInfoVo.setSpuId(spuId);
        addGoodsSkuInfoVo.setSkuNo(goodsInfoVo.getSpuNo());
        addGoodsSkuInfoVo.setName(goodsInfoVo.getName());
        addGoodsSkuInfoVo.setSubtitle(goodsInfoVo.getSubtitle());
        addGoodsSkuInfoVo.setVirtualFlg(goodsInfoVo.getVirtualFlg());
        addGoodsSkuInfoVo.setStatus("3");
        addGoodsSkuInfoVo.setShelvesStatus(goodsInfoVo.getShelvesStatus());
        addGoodsSkuInfoVo.setCreatedAt(now);
        addGoodsSkuInfoVo.setCreatedBy(uid);
        addGoodsSkuInfoVo.setLogisticsTemplate(goodsInfoVo.getLogisticsTemplate());

        goblinMongoUtils.setGoodsSkuInfoVo(addGoodsSkuInfoVo);

        List<String> skuIdList = goodsInfoVo.getSkuIdList();
        skuIdList.add(addGoodsSkuInfoVo.getSkuId());
        goodsInfoVo.setSkuIdList(skuIdList);

        goblinMongoUtils.updateGoodsInfoVo(goodsInfoVo);

        // TODO: 2022/1/5 zhanggb redis+sql
    }

    @Override
    public boolean goodsEditSkuDel(GoblinGoodsSkuInfoVo goodsSkuInfoVo) {
        String skuId = goodsSkuInfoVo.getSkuId();

        GoblinGoodsInfoVo mgtGoodsInfoVo = goblinRedisUtils.getMgtGoodsInfoVo(goodsSkuInfoVo.getSpuId());
        List<String> skuIdList = mgtGoodsInfoVo.getSkuIdList();
        skuIdList.removeIf(r -> r.equals(skuId));
        mgtGoodsInfoVo.setSkuIdList(skuIdList);

        List<GoblinGoodsSpecVo> specVoList = mgtGoodsInfoVo.getSpecVoList();
        Map<String, String> delGoodsSkuSpecMap = goodsSkuInfoVo.getSkuSpecList().stream()
                .collect(Collectors.toMap(GoblinGoodsSpecDto::getSpecName, GoblinGoodsSpecDto::getSpecVname, (k1, k2) -> k2));
        for (int i = 0; i < specVoList.size(); i++) {// 处理商品规格信息
            GoblinGoodsSpecVo specVo = specVoList.get(i);
            List<GoblinGoodsSpecValueVo> modifySpecValues = ObjectUtil.getGoblinGoodsSpecValueVoArrayList();

            String delSpecVname = delGoodsSkuSpecMap.get(specVo.getSpecName());
            List<GoblinGoodsSpecValueVo> specValues = specVo.getSpecValues();
            Integer rmIdx = null;
            for (GoblinGoodsSpecValueVo specValue : specValues) {
                if (specValue.getSpecVname().equals(delSpecVname)) {
                    modifySpecValues.remove(specValue);
                    rmIdx = specValue.getSpecVsort();
                } else {
                    modifySpecValues.add(specValue);
                }
                if (null != rmIdx && specValue.getSpecVsort() > rmIdx) {
                    specValue.setSpecVsort(specValue.getSpecVsort() - 1);
                }
            }
            if (modifySpecValues.size() == 0) {// 规格下规格值为0的时候，移除规格
                specVoList.remove(specVo);
            } else {
                specVo.setSpecValues(modifySpecValues);
            }
        }

        goblinMongoUtils.delGoodsSkuInfoVo(skuId);
        goblinRedisUtils.delGoodsSkuInfoVo(skuId);

        // TODO: 2022/1/5 zhanggb redis+sql

        return goblinMongoUtils.updateGoodsInfoVo(mgtGoodsInfoVo);
    }

    @Override
    public boolean goodsEditSkuBat(String spuId, String batField, String batFieldVal) {
        // TODO: 2022/1/5 zhanggb
        return false;
    }

    @Override
    public void goodsOnshelves(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam) {
        // TODO: 2021/12/28 zhanggb
    }

    @Override
    public void goodsUnshelves(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam) {
        // TODO: 2021/12/28 zhanggb
    }

    @Override
    public void goodsRemove(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam) {
        // TODO: 2021/12/28 zhanggb
    }
}
