package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinRecommendActiveRelationVo;
import com.liquidnet.service.kylin.dto.vo.KylinRecommendActiveVo;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.service.impl.KylinRecommendActiveServiceImpl;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *   推荐活动
 * </p>
 *
 */

@Api(tags = "推荐活动有关接口")
@RestController
@RequestMapping("recommendActive")
@Slf4j
public class KylinRecommendActiveController {
    @Autowired
    private KylinRecommendActiveServiceImpl kylinRecommendActiveService;
    @Autowired
    private DataUtils dataUtils;

    @PostMapping("getRecommendById")
    @ApiOperation("获取推荐活动详情")
    public ResponseDto<KylinRecommendActiveVo> getRecommendById(@RequestParam(value = "bindId")String bindId) {
        List<KylinRecommendActive> list= dataUtils.getRecommendActive(bindId);
        if(null==list){
            return  ResponseDto.success(null);
        }else{
            //循环遍历，查到绑定的详情
            return  ResponseDto.success(kylinRecommendActiveService.getRecommendById(list));
        }
    }
    @PostMapping("getRecommendByIds")
    @ApiOperation("获取推荐活动详情，多id的")
    public ResponseDto<List<KylinRecommendActiveRelationVo>> getRecommendByIds(@RequestParam(value = "ids")List<String> ids) {
        ArrayList<KylinRecommendActiveRelationVo> resultList = ObjectUtil.getKylinRecommendActiveRelationVo();
        for(String id:ids){
            List<KylinRecommendActive> list= dataUtils.getRecommendActive(id);
            if(null!=list&&list.size()>0){
                KylinRecommendActiveVo kylinRecommendActiveVo = kylinRecommendActiveService.getRecommendById(list);
                List<KylinRecommendActiveRelationVo> list1 = kylinRecommendActiveVo.getList();
                for(KylinRecommendActiveRelationVo ky:list1){
                    resultList.add(ky);
                    //只搜索20个
                    if(resultList.size()==20){
                        return ResponseDto.success(resultList) ;
                    }
                }
            }
        }
        return  ResponseDto.success(resultList);
    }



}
