package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.manage.*;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;

import java.util.List;

public interface IGoblinstoreMgtGoodsService {
    /**
     * 商品管理:SPU列表
     *
     * @param storeMgtGoodsFilterParam GoblinStoreMgtGoodsFilterParam
     * @return PagedResult<GoblinStoreMgtGoodsVo>
     */
    PagedResult<GoblinStoreMgtGoodsListVo> goodsList(GoblinStoreMgtGoodsFilterParam storeMgtGoodsFilterParam);

    /**
     * 商品管理:SPU添加
     *
     * @param goodsInfoVo        GoblinGoodsInfoVo
     * @param goodsSkuInfoVoList List<GoblinGoodsSkuInfoVo>
     */
    void goodsAdd(GoblinGoodsInfoVo goodsInfoVo, List<GoblinGoodsSkuInfoVo> goodsSkuInfoVoList);

    /**
     * 商品管理:SPU详情
     *
     * @param storeId 店铺ID
     * @param spuId   商品ID
     * @return GoblinStoreMgtGoodsInfoVo
     */
    GoblinStoreMgtGoodsInfoVo goodsInfo(String storeId, String spuId);

    /**
     * 商品管理:商品编辑:SPU编辑
     *
     * @param storeMgtGoodsAddParam GoblinStoreMgtGoodsAddParam
     * @return boolean
     */
    boolean goodsEditSpu(GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam);

    /**
     * 商品管理:商品编辑:SKU编辑
     *
     * @param uid                       UID
     * @param storeMgtGoodsEditSkuParam GoblinStoreMgtGoodsEditSkuParam
     * @param goodsInfoVo               GoblinGoodsInfoVo
     * @return boolean
     */
    boolean goodsEditSku(String uid, GoblinStoreMgtGoodsEditSkuParam storeMgtGoodsEditSkuParam, GoblinGoodsInfoVo goodsInfoVo);

    /**
     * 商品管理:商品编辑:SKU添加
     *
     * @param storeMgtGoodsEditSkuParam GoblinStoreMgtGoodsEditSkuParam
     * @param goodsInfoVo               GoblinGoodsInfoVo
     */
    void goodsEditSkuAdd(GoblinStoreMgtGoodsEditSkuParam storeMgtGoodsEditSkuParam, GoblinGoodsInfoVo goodsInfoVo);

    /**
     * 商品管理:商品编辑:SKU删除
     *
     * @param goodsSkuInfoVo GoblinGoodsSkuInfoVo
     * @return boolean
     */
    boolean goodsEditSkuDel(GoblinGoodsSkuInfoVo goodsSkuInfoVo);

    /**
     * 商品管理:商品编辑:SKU批改
     *
     * @param spuId       商品ID
     * @param batField    批量修改属性
     * @param batFieldVal 批量修改属性值
     * @return boolean
     */
    boolean goodsEditSkuBat(String spuId, String batField, String batFieldVal);

    /**
     * 商品管理:上下架商品
     *
     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     * @param uid                      UID
     * @param shelvesFlg               true:上架|false:下架
     */
    void goodsShelvesProcessing(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam, String uid, boolean shelvesFlg);

    /**
     * 商品管理:删除商品
     *
     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     * @param uid                      UID
     */
    void goodsRemove(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam, String uid);
}
