package com.liquidnet.client.admin.zhengzai.merchant.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantCompaniesAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantFieldAppliesAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantFieldsAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.utils.MerchantMongoUtil;
import com.liquidnet.client.admin.zhengzai.merchant.utils.MerchantRedisUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.merchant.dto.vo.MerchantCompaniesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldAppliesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.liquidnet.service.merchant.entity.MerchantCompanies;
import com.liquidnet.service.merchant.entity.MerchantFieldApplies;
import com.liquidnet.service.merchant.entity.MerchantFields;
import com.liquidnet.service.merchant.mapper.MerchantFieldAppliesMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class MerchantFieldAppliesAdminServiceImpl extends ServiceImpl<MerchantFieldAppliesMapper, MerchantFieldApplies> implements IMerchantFieldAppliesAdminService {

    @Autowired
    MerchantRedisUtil merchantRedisUtil;

    @Autowired
    MerchantMongoUtil merchantMongoUtil;

    @Autowired
    MongoTemplate mongoTemplate;


    @Autowired
    IMerchantFieldsAdminService merchantFieldsAdminService;

    @Autowired
    IMerchantCompaniesAdminService merchantCompaniesAdminService;


    @Override
    @Transactional
    public boolean applyApprove(String fieldApplyId, String auditUid, String auditName) {
        LocalDateTime now = LocalDateTime.now();

        // 场地申请 entity
        LambdaQueryWrapper<MerchantFieldApplies> fieldAppliesLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantFieldApplies.class);
        fieldAppliesLambdaQueryWrapper.eq(MerchantFieldApplies::getFieldApplyId, fieldApplyId);
        MerchantFieldApplies fieldAppliesEntity = getOne(fieldAppliesLambdaQueryWrapper);
        if (0 != fieldAppliesEntity.getApplyStatus()) {
            // todo error
            throw new LiquidnetServiceException();
        }

        if (fieldAppliesEntity.getApplyType().equals("claim")) {
            // 认领逻辑

            // 公司 entity mysql
            MerchantCompanies companiesEntity = new MerchantCompanies();
            companiesEntity.setCompanyId(IDGenerator.nextSnowId());
            companiesEntity.setName(fieldAppliesEntity.getCompanyName());
            companiesEntity.setLicenseCode(fieldAppliesEntity.getLicenseCode());
            companiesEntity.setLicenseImg(fieldAppliesEntity.getLicenseImg());
            companiesEntity.setLegalName(fieldAppliesEntity.getLegalName());
            companiesEntity.setLegalIdentity(fieldAppliesEntity.getLegalIdentity());
            companiesEntity.setLegalIdentityObverse(fieldAppliesEntity.getLegalIdentityObverse());
            companiesEntity.setLegalIdentityReverse(fieldAppliesEntity.getLegalIdentityReverse());
            companiesEntity.setCreatedAt(now);
            boolean success = merchantCompaniesAdminService.save(companiesEntity);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地 entity mysql
            LambdaQueryWrapper<MerchantFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantFields.class);
            fieldsLambdaQueryWrapper.eq(MerchantFields::getFieldId, fieldAppliesEntity.getFieldId());
            MerchantFields fieldsEntity = merchantFieldsAdminService.getOne(fieldsLambdaQueryWrapper);
            if (null == fieldsEntity) {
                // todo error
                throw new LiquidnetServiceException();
            }
            if (2 != fieldsEntity.getClaimStatus() || !fieldsEntity.getUid().equals(fieldAppliesEntity.getUid())) {
                // todo error
                throw new LiquidnetServiceException();
            }
            fieldsEntity.setIsOnline(1);
            fieldsEntity.setClaimStatus(1);
            fieldsEntity.setUid(fieldAppliesEntity.getUid());
            fieldsEntity.setIsCheck(0);
            fieldsEntity.setName(fieldAppliesEntity.getName());
            fieldsEntity.setLogo(fieldAppliesEntity.getLogo());
            fieldsEntity.setBackground(fieldAppliesEntity.getBackground());
            fieldsEntity.setDescription(fieldAppliesEntity.getDescription());
            fieldsEntity.setBuiltDate(fieldAppliesEntity.getBuiltDate());
            fieldsEntity.setProvinceId(fieldAppliesEntity.getProvinceId());
            fieldsEntity.setProvinceName(fieldAppliesEntity.getProvinceName());
            fieldsEntity.setCityId(fieldAppliesEntity.getCityId());
            fieldsEntity.setCityName(fieldAppliesEntity.getCityName());
            fieldsEntity.setDistrictId(fieldAppliesEntity.getDistrictId());
            fieldsEntity.setDistrictName(fieldAppliesEntity.getDistrictName());
            fieldsEntity.setAddress(fieldAppliesEntity.getAddress());
            fieldsEntity.setLongitude(fieldAppliesEntity.getLongitude());
            fieldsEntity.setLatitude(fieldAppliesEntity.getLatitude());
            fieldsEntity.setContactName(fieldAppliesEntity.getContactName());
            fieldsEntity.setContactEmail(fieldAppliesEntity.getContactEmail());
            fieldsEntity.setCompanyId(companiesEntity.getCompanyId());
            fieldsEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<MerchantFields> fieldsLambdaUpdateWrapper = Wrappers.lambdaUpdate(MerchantFields.class);
            fieldsLambdaUpdateWrapper.eq(MerchantFields::getFieldId, fieldsEntity.getFieldId());
            success = merchantFieldsAdminService.update(fieldsEntity, fieldsLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地申请 entity mysql
            fieldAppliesEntity.setApplyStatus(1);
            fieldAppliesEntity.setReject("");
            fieldAppliesEntity.setAuditUid(auditUid);
            fieldAppliesEntity.setAuditName(auditName);
            fieldAppliesEntity.setAuditedAt(now);
            fieldAppliesEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<MerchantFieldApplies> fieldAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(MerchantFieldApplies.class);
            fieldAppliesLambdaUpdateWrapper.eq(MerchantFieldApplies::getFieldApplyId, fieldAppliesEntity.getFieldApplyId());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getApplyStatus, fieldAppliesEntity.getApplyStatus());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getReject, fieldAppliesEntity.getReject());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditUid, fieldAppliesEntity.getAuditUid());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditName, fieldAppliesEntity.getAuditName());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditedAt, fieldAppliesEntity.getAuditedAt());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getUpdatedAt, fieldAppliesEntity.getUpdatedAt());
            success = update(fieldAppliesLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 公司 vo
            MerchantCompaniesVo companiesVo = MerchantCompaniesVo.getNew();
            companiesVo.copy(companiesEntity);

            // 场地 vo
            MerchantFieldsVo fieldsVo = MerchantFieldsVo.getNew();
            fieldsVo.copy(fieldsEntity);
            fieldsVo.setCompaniesVo(companiesVo);

            // 场地申请 vo
            MerchantFieldAppliesVo fieldAppliesVo = MerchantFieldAppliesVo.getNew();
            fieldAppliesVo.copy(fieldAppliesEntity);

            // 场地 sync mongo
            merchantMongoUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地 sync redis
            merchantRedisUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地申请 sync mongo
            Query query = Query.query(Criteria.where("fieldApplyId").is(fieldAppliesVo.getFieldApplyId()));
            Update update = Update.update("applyStatus", fieldAppliesVo.getApplyStatus());
            update.set("reject", fieldAppliesVo.getReject());
            update.set("auditUid", fieldAppliesVo.getAuditUid());
            update.set("auditName", fieldAppliesVo.getAuditName());
            update.set("auditedAt", fieldAppliesVo.getAuditedAt());
            update.set("updatedAt", fieldAppliesVo.getUpdatedAt());
            mongoTemplate.updateFirst(query, update, MerchantFieldAppliesVo.class, MerchantFieldAppliesVo.class.getSimpleName());

            // 场地申请 sync redis
            List<MerchantFieldAppliesVo> fieldAppliesVos = merchantRedisUtil.getFieldAppliesVosByUid(fieldAppliesVo.getUid());
            merchantRedisUtil.setFieldAppliesVoByUid(fieldAppliesVo.getUid(), fieldAppliesVos, fieldAppliesVo);
        } else {
            // 创建逻辑

            // 公司 entity mysql
            MerchantCompanies companiesEntity = new MerchantCompanies();
            companiesEntity.setCompanyId(IDGenerator.nextSnowId());
            companiesEntity.setName(fieldAppliesEntity.getCompanyName());
            companiesEntity.setLicenseCode(fieldAppliesEntity.getLicenseCode());
            companiesEntity.setLicenseImg(fieldAppliesEntity.getLicenseImg());
            companiesEntity.setLegalName(fieldAppliesEntity.getLegalName());
            companiesEntity.setLegalIdentity(fieldAppliesEntity.getLegalIdentity());
            companiesEntity.setLegalIdentityObverse(fieldAppliesEntity.getLegalIdentityObverse());
            companiesEntity.setLegalIdentityReverse(fieldAppliesEntity.getLegalIdentityReverse());
            companiesEntity.setCreatedAt(now);
            boolean success = merchantCompaniesAdminService.save(companiesEntity);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地 entity mysql
            MerchantFields fieldsEntity = new MerchantFields();
            fieldsEntity.setFieldId(IDGenerator.nextSnowId());
            fieldsEntity.setIsOnline(1);
            fieldsEntity.setClaimStatus(1);
            fieldsEntity.setUid(fieldAppliesEntity.getUid());
            fieldsEntity.setIsCheck(0);
            fieldsEntity.setName(fieldAppliesEntity.getName());
            fieldsEntity.setLogo(fieldAppliesEntity.getLogo());
            fieldsEntity.setBackground(fieldAppliesEntity.getBackground());
            fieldsEntity.setDescription(fieldAppliesEntity.getDescription());
            fieldsEntity.setBuiltDate(fieldAppliesEntity.getBuiltDate());
            fieldsEntity.setProvinceId(fieldAppliesEntity.getProvinceId());
            fieldsEntity.setProvinceName(fieldAppliesEntity.getProvinceName());
            fieldsEntity.setCityId(fieldAppliesEntity.getCityId());
            fieldsEntity.setCityName(fieldAppliesEntity.getCityName());
            fieldsEntity.setDistrictId(fieldAppliesEntity.getDistrictId());
            fieldsEntity.setDistrictName(fieldAppliesEntity.getDistrictName());
            fieldsEntity.setAddress(fieldAppliesEntity.getAddress());
            fieldsEntity.setLongitude(fieldAppliesEntity.getLongitude());
            fieldsEntity.setLatitude(fieldAppliesEntity.getLatitude());
            fieldsEntity.setContactName(fieldAppliesEntity.getContactName());
            fieldsEntity.setContactEmail(fieldAppliesEntity.getContactEmail());
            fieldsEntity.setCompanyId(companiesEntity.getCompanyId());
            fieldsEntity.setCreatedAt(now);
            success = merchantFieldsAdminService.save(fieldsEntity);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地申请 entity mysql
            fieldAppliesEntity.setApplyStatus(1);
            fieldAppliesEntity.setReject("");
            fieldAppliesEntity.setAuditUid(auditUid);
            fieldAppliesEntity.setAuditName(auditName);
            fieldAppliesEntity.setAuditedAt(now);
            fieldAppliesEntity.setUpdatedAt(now);
            fieldAppliesEntity.setFieldId(fieldsEntity.getFieldId());
            LambdaUpdateWrapper<MerchantFieldApplies> fieldAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(MerchantFieldApplies.class);
            fieldAppliesLambdaUpdateWrapper.eq(MerchantFieldApplies::getFieldApplyId, fieldAppliesEntity.getFieldApplyId());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getApplyStatus, fieldAppliesEntity.getApplyStatus());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getReject, fieldAppliesEntity.getReject());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditUid, fieldAppliesEntity.getAuditUid());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditName, fieldAppliesEntity.getAuditName());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditedAt, fieldAppliesEntity.getAuditedAt());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getUpdatedAt, fieldAppliesEntity.getUpdatedAt());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getFieldId, fieldAppliesEntity.getFieldId());
            success = update(fieldAppliesLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 公司 vo
            MerchantCompaniesVo companiesVo = MerchantCompaniesVo.getNew();
            companiesVo.copy(companiesEntity);

            // 场地 vo
            MerchantFieldsVo fieldsVo = MerchantFieldsVo.getNew();
            fieldsVo.copy(fieldsEntity);
            fieldsVo.setCompaniesVo(companiesVo);

            // 场地申请 vo
            MerchantFieldAppliesVo fieldAppliesVo = MerchantFieldAppliesVo.getNew();
            fieldAppliesVo.copy(fieldAppliesEntity);

            // 场地 sync mongo
            merchantMongoUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地 sync redis
            merchantRedisUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地申请 sync mongo
            Query query = Query.query(Criteria.where("fieldApplyId").is(fieldAppliesVo.getFieldApplyId()));
            Update update = Update.update("applyStatus", fieldAppliesVo.getApplyStatus());
            update.set("reject", fieldAppliesVo.getReject());
            update.set("auditUid", fieldAppliesVo.getAuditUid());
            update.set("auditName", fieldAppliesVo.getAuditName());
            update.set("auditedAt", fieldAppliesVo.getAuditedAt());
            update.set("updatedAt", fieldAppliesVo.getUpdatedAt());
            update.set("fieldId", fieldAppliesVo.getFieldId());
            mongoTemplate.updateFirst(query, update, MerchantFieldAppliesVo.class, MerchantFieldAppliesVo.class.getSimpleName());

            // 场地申请 sync redis
            List<MerchantFieldAppliesVo> fieldAppliesVos = merchantRedisUtil.getFieldAppliesVosByUid(fieldAppliesVo.getUid());
            merchantRedisUtil.setFieldAppliesVoByUid(fieldAppliesVo.getUid(), fieldAppliesVos, fieldAppliesVo);
        }

        return true;
    }

    @Override
    public boolean applyReject(String fieldApplyId, String auditUid, String auditName, String reject) {
        LocalDateTime now = LocalDateTime.now();

        // 场地申请 entity
        LambdaQueryWrapper<MerchantFieldApplies> fieldAppliesLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantFieldApplies.class);
        fieldAppliesLambdaQueryWrapper.eq(MerchantFieldApplies::getFieldApplyId, fieldApplyId);
        MerchantFieldApplies fieldAppliesEntity = getOne(fieldAppliesLambdaQueryWrapper);
        if (0 != fieldAppliesEntity.getApplyStatus()) {
            // todo error
            throw new LiquidnetServiceException();
        }

        if (fieldAppliesEntity.getApplyType().equals("claim")) {
            // 驳回认领逻辑

            // 场地 entity mysql
            LambdaQueryWrapper<MerchantFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantFields.class);
            fieldsLambdaQueryWrapper.eq(MerchantFields::getFieldId, fieldAppliesEntity.getFieldId());
            MerchantFields fieldsEntity = merchantFieldsAdminService.getOne(fieldsLambdaQueryWrapper);
            if (null == fieldsEntity) {
                // todo error
                throw new LiquidnetServiceException();
            }
            if (2 != fieldsEntity.getClaimStatus() || !fieldsEntity.getUid().equals(fieldAppliesEntity.getUid())) {
                // todo error
                throw new LiquidnetServiceException();
            }
            fieldsEntity.setClaimStatus(0);
            fieldsEntity.setUid("");
            fieldsEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<MerchantFields> fieldsLambdaUpdateWrapper = Wrappers.lambdaUpdate(MerchantFields.class);
            fieldsLambdaUpdateWrapper.eq(MerchantFields::getFieldId, fieldsEntity.getFieldId());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getClaimStatus, fieldsEntity.getClaimStatus());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getUid, fieldsEntity.getUid());
            fieldsLambdaUpdateWrapper.set(MerchantFields::getUpdatedAt, fieldsEntity.getUpdatedAt());
            boolean success = merchantFieldsAdminService.update(fieldsLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地申请 entity mysql
            fieldAppliesEntity.setApplyStatus(2);
            fieldAppliesEntity.setReject(reject);
            fieldAppliesEntity.setAuditUid(auditUid);
            fieldAppliesEntity.setAuditName(auditName);
            fieldAppliesEntity.setAuditedAt(now);
            fieldAppliesEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<MerchantFieldApplies> fieldAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(MerchantFieldApplies.class);
            fieldAppliesLambdaUpdateWrapper.eq(MerchantFieldApplies::getFieldApplyId, fieldAppliesEntity.getFieldApplyId());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getApplyStatus, fieldAppliesEntity.getApplyStatus());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getReject, fieldAppliesEntity.getReject());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditUid, fieldAppliesEntity.getAuditUid());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditName, fieldAppliesEntity.getAuditName());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditedAt, fieldAppliesEntity.getAuditedAt());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getUpdatedAt, fieldAppliesEntity.getUpdatedAt());
            success = update(fieldAppliesLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地 vo
            MerchantFieldsVo fieldsVo = merchantRedisUtil.getFieldsVoByFieldId(fieldsEntity.getFieldId());
            fieldsVo.setClaimStatus(0);
            fieldsVo.setUid("");
            fieldsVo.setUpdatedAt(now);

            // 场地申请 vo
            MerchantFieldAppliesVo fieldAppliesVo = MerchantFieldAppliesVo.getNew();
            fieldAppliesVo.copy(fieldAppliesEntity);

            // 场地 sync mongo
            merchantMongoUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地 sync redis
            merchantRedisUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

            // 场地申请 sync mongo
            Query query = Query.query(Criteria.where("fieldApplyId").is(fieldAppliesVo.getFieldApplyId()));
            Update update = Update.update("applyStatus", fieldAppliesVo.getApplyStatus());
            update.set("reject", fieldAppliesVo.getReject());
            update.set("auditUid", fieldAppliesVo.getAuditUid());
            update.set("auditName", fieldAppliesVo.getAuditName());
            update.set("auditedAt", fieldAppliesVo.getAuditedAt());
            update.set("updatedAt", fieldAppliesVo.getUpdatedAt());
            mongoTemplate.updateFirst(query, update, MerchantFieldAppliesVo.class, MerchantFieldAppliesVo.class.getSimpleName());

            // 场地申请 sync redis
            List<MerchantFieldAppliesVo> fieldAppliesVos = merchantRedisUtil.getFieldAppliesVosByUid(fieldAppliesVo.getUid());
            merchantRedisUtil.setFieldAppliesVoByUid(fieldAppliesVo.getUid(), fieldAppliesVos, fieldAppliesVo);
        } else {
            // 驳回创建逻辑

            // 场地申请 entity mysql
            fieldAppliesEntity.setApplyStatus(2);
            fieldAppliesEntity.setReject(reject);
            fieldAppliesEntity.setAuditUid(auditUid);
            fieldAppliesEntity.setAuditName(auditName);
            fieldAppliesEntity.setAuditedAt(now);
            fieldAppliesEntity.setUpdatedAt(now);
            LambdaUpdateWrapper<MerchantFieldApplies> fieldAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(MerchantFieldApplies.class);
            fieldAppliesLambdaUpdateWrapper.eq(MerchantFieldApplies::getFieldApplyId, fieldAppliesEntity.getFieldApplyId());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getApplyStatus, fieldAppliesEntity.getApplyStatus());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getReject, fieldAppliesEntity.getReject());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditUid, fieldAppliesEntity.getAuditUid());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditName, fieldAppliesEntity.getAuditName());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getAuditedAt, fieldAppliesEntity.getAuditedAt());
            fieldAppliesLambdaUpdateWrapper.set(MerchantFieldApplies::getUpdatedAt, fieldAppliesEntity.getUpdatedAt());
            boolean success = update(fieldAppliesLambdaUpdateWrapper);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }

            // 场地申请 vo
            MerchantFieldAppliesVo fieldAppliesVo = MerchantFieldAppliesVo.getNew();
            fieldAppliesVo.copy(fieldAppliesEntity);

            // 场地申请 sync mongo
            Query query = Query.query(Criteria.where("fieldApplyId").is(fieldAppliesVo.getFieldApplyId()));
            Update update = Update.update("applyStatus", fieldAppliesVo.getApplyStatus());
            update.set("reject", fieldAppliesVo.getReject());
            update.set("auditUid", fieldAppliesVo.getAuditUid());
            update.set("auditName", fieldAppliesVo.getAuditName());
            update.set("auditedAt", fieldAppliesVo.getAuditedAt());
            update.set("updatedAt", fieldAppliesVo.getUpdatedAt());
            mongoTemplate.updateFirst(query, update, MerchantFieldAppliesVo.class, MerchantFieldAppliesVo.class.getSimpleName());

            // 场地申请 sync redis
            List<MerchantFieldAppliesVo> fieldAppliesVos = merchantRedisUtil.getFieldAppliesVosByUid(fieldAppliesVo.getUid());
            merchantRedisUtil.setFieldAppliesVoByUid(fieldAppliesVo.getUid(), fieldAppliesVos, fieldAppliesVo);
        }

        return true;
    }


}
