package com.liquidnet.client.admin.zhengzai.merchant.utils;

import com.liquidnet.service.merchant.constant.MerchantAuthorizationConst;
import com.liquidnet.service.merchant.dto.vo.*;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class MerchantMongoUtil {
    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;


    public MerchantFieldsVo getFieldsVoByFieldId(String fieldId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("fieldId").is(fieldId)), MerchantFieldsVo.class, MerchantFieldsVo.class.getSimpleName());
    }

    public void setFieldsVoByFieldId(String fieldId, MerchantFieldsVo vo) {
        Query query = Query.query(Criteria.where("fieldId").is(fieldId));
        Document document = (Document)mongoConverter.convertToMongoType(vo);
        Update update = Update.fromDocument(document);
        mongoTemplate.upsert(query, update, MerchantFieldsVo.class, MerchantFieldsVo.class.getSimpleName());
    }

    public MerchantSponsorsVo getSponsorsVoBySponsorId(String sponsorId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("sponsorId").is(sponsorId)), MerchantSponsorsVo.class, MerchantSponsorsVo.class.getSimpleName());
    }

    public void setSponsorsVoBySponsorId(String sponsorId, MerchantSponsorsVo vo) {
        Query query = Query.query(Criteria.where("sponsorId").is(sponsorId));
        Document document = (Document)mongoConverter.convertToMongoType(vo);
        Update update = Update.fromDocument(document);
        mongoTemplate.upsert(query, update, MerchantSponsorsVo.class, MerchantSponsorsVo.class.getSimpleName());
    }

    public MerchantAuthorizationPerformanceVo getAuthorizationPerformanceVo(String performanceId, String uid) {
        return mongoTemplate.findOne(Query.query(Criteria.where("performanceId").is(performanceId).and("uid").is(uid)), MerchantAuthorizationPerformanceVo.class, MerchantAuthorizationPerformanceVo.class.getSimpleName());
    }

    public MerchantAuthorizationPerformanceVo getAndSyncAuthorizationPerformanceVo(String performanceId, String uid) {
        // 聚合角色及权限
        Query recordsQuery = Query.query(Criteria.where("performanceId").is(performanceId).and("uid").is(uid).and("deletedAt").is(null));
        List<MerchantAuthorizationRecordsVo> authorizationRecordsVos = mongoTemplate.find(recordsQuery, MerchantAuthorizationRecordsVo.class, MerchantAuthorizationRecordsVo.class.getSimpleName());
        List<String> uidRoles = new ArrayList<>();
        List<String> permissionIds = new ArrayList<>();
        for (MerchantAuthorizationRecordsVo authorizationRecordsVo: authorizationRecordsVos) {
            if (!uidRoles.contains(authorizationRecordsVo.getUidRole())) {
                uidRoles.add(authorizationRecordsVo.getUidRole());
            }
            for (MerchantAuthorizationPermissionsVo authorizationPermissionsVo: authorizationRecordsVo.getPermissionsVos()) {
                if (!permissionIds.contains(authorizationPermissionsVo.getPermissionId())) {
                    permissionIds.add(authorizationPermissionsVo.getPermissionId());
                }
            }
        }
        MerchantAuthorizationPerformanceVo vo = MerchantAuthorizationPerformanceVo.getNew();
        vo.setUid(uid);
        vo.setPerformanceId(performanceId);
        vo.setUidRoles(uidRoles);
        vo.setPermissionIds(permissionIds);
        Query query = Query.query(Criteria.where("performanceId").is(performanceId).and("uid").is(uid));
        Document document = (Document)mongoConverter.convertToMongoType(vo);
        Update update = Update.fromDocument(document);
        mongoTemplate.upsert(query, update, MerchantAuthorizationPerformanceVo.class, MerchantAuthorizationPerformanceVo.class.getSimpleName());
        return vo;
    }

    public List<MerchantFieldAppliesVo> getFieldAppliesVosByUid(String uid) {
        Query query = Query.query(Criteria.where("uid").is(uid).and("deletedAt").is(null));
        return mongoTemplate.find(query, MerchantFieldAppliesVo.class, MerchantFieldAppliesVo.class.getSimpleName());
    }

    public List<MerchantSponsorAppliesVo> getSponsorAppliesVosByUid(String uid) {
        Query query = Query.query(Criteria.where("uid").is(uid).and("deletedAt").is(null));
        return mongoTemplate.find(query, MerchantSponsorAppliesVo.class, MerchantSponsorAppliesVo.class.getSimpleName());
    }

    public List<MerchantAuthorizationRecordsVo> getAuthorizationRecordsCheckersVosByCuid(String cuid, String performanceId) {
        Query query = Query.query(Criteria.where("uidRole").is(MerchantAuthorizationConst.PerformanceRole.CHECKER.getRole()).and("cuid").is(cuid).and("performanceId").is(performanceId).and("deletedAt").is(null));
        return mongoTemplate.find(query, MerchantAuthorizationRecordsVo.class, MerchantAuthorizationRecordsVo.class.getSimpleName());
    }
}
