package com.liquidnet.client.admin.zhengzai.merchant.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.utils.bean.BeanUtils;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantCompaniesAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantFieldsAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.utils.MerchantMongoUtil;
import com.liquidnet.client.admin.zhengzai.merchant.utils.MerchantRedisUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.service.merchant.dto.param.admin.MerchantFieldEditParam;
import com.liquidnet.service.merchant.dto.vo.MerchantCompaniesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.liquidnet.service.merchant.entity.MerchantCompanies;
import com.liquidnet.service.merchant.entity.MerchantFields;
import com.liquidnet.service.merchant.mapper.MerchantFieldsMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
public class MerchantFieldsAdminServiceImpl extends ServiceImpl<MerchantFieldsMapper, MerchantFields> implements IMerchantFieldsAdminService {

    @Autowired
    MerchantRedisUtil merchantRedisUtil;

    @Autowired
    MerchantMongoUtil merchantMongoUtil;

    @Autowired
    IMerchantCompaniesAdminService merchantCompaniesAdminService;

    @Override
    public boolean fieldEdit(MerchantFieldEditParam parameter) {
        LocalDateTime now = LocalDateTime.now();

        // 查询场地 entity
        LambdaQueryWrapper<MerchantFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantFields.class);
        fieldsLambdaQueryWrapper.eq(MerchantFields::getFieldId, parameter.getFieldId());
        MerchantFields fieldsEntity = getOne(fieldsLambdaQueryWrapper);
        if (null == fieldsEntity) {
            // todo error
            throw new LiquidnetServiceException();
        }

        // 场地 entity
        BeanUtils.copyProperties(parameter, fieldsEntity);
        fieldsEntity.setUpdatedAt(now);

        // 场地 mysql
        updateById(fieldsEntity);

        // 场地 vo
        MerchantFieldsVo fieldsVo = MerchantFieldsVo.getNew();
        fieldsVo.copy(fieldsEntity);
        if (null != fieldsVo.getCompanyId() && !fieldsVo.getCompanyId().isEmpty()) {
            LambdaQueryWrapper<MerchantCompanies> companiesLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantCompanies.class);
            companiesLambdaQueryWrapper.eq(MerchantCompanies::getCompanyId, fieldsVo.getCompanyId());
            MerchantCompanies companies = merchantCompaniesAdminService.getOne(companiesLambdaQueryWrapper);

            MerchantCompaniesVo companiesVo = MerchantCompaniesVo.getNew();
            companiesVo.copy(companies);
            fieldsVo.setCompaniesVo(companiesVo);
        }

        // 场地 mongo
        merchantMongoUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

        // 场地 redis
        merchantRedisUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

        return true;
    }
}
