package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 会员价格
 */
@ApiModel(value = "AdamMemberCodeParam", description = "添加编辑会员兑换码")
@Data
public class AdamMemberCodeParam implements Serializable {

    private static final long serialVersionUID = 5940725094369061032L;

    /**
     * 会员类型ID
     */
    @ApiModelProperty(position = 1, required = false, value = "会员类型ID")
    private String memberId;

    /**
     * 会员价格ID
     */
    @ApiModelProperty(position = 2, required = false, value = "会员价格ID")
    private String memberPriceId;

    /**
     * 类型 0-用户购买兑换码 1-后台生成兑换码
     */
    @ApiModelProperty(position = 3, required = true, value = "类型 0-用户购买兑换码 1-后台生成兑换码", example = "0")
    private Integer type;

    /**
     *  购买会员码的用户id
     */
    @ApiModelProperty(position = 4, required = false, value = "登录用户token，应该从token里拿", example = "0")
    private String buyUid;

}
