package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "AdamMemberOrderParam", description = "入场人响应")
@Data
public class AdamMemberOrderParam implements Serializable {
    private static final long serialVersionUID = 3219448286221952517L;
    /**
     * 会员卡id
     */
    @ApiModelProperty(position = 0, required = true, value = "会员ID[50]", example = "62960077673504768")
    private String memberId;
    @ApiModelProperty(position = 1, required = true, value = "购买方式:0-购买会员 1-购买会员码,2-使用会员码", example = "0")
    private Integer mode;
    @ApiModelProperty(position = 2, required = true, value = "应付金额", example = "0")
    private BigDecimal price;
    @ApiModelProperty(position = 3, required = true, value = "实付金额", example = "0")
    private BigDecimal pricePaid;
    @ApiModelProperty(position = 4, required = true, value = "会员价格id", example = "0")
    private String memberPriceId;
    @ApiModelProperty(position = 5, required = false, value = "先这么写，应该从token取才对", example = "0")
    private String uid;
    @ApiModelProperty(position = 6, required = true, value = "用户生日", example = "0")
    private LocalDateTime birthday;
    /**
     * 支付方式
     * ALIPAY,WEPAY,WAPALIPAY,WAPWEPAY,JSWEPAY,APPLETWEPAY,APPIAP
     */
    @ApiModelProperty(position = 7, required = true, value = "支付方式：ALIPAY,WEPAY,WAPALIPAY,WAPWEPAY,JSWEPAY,APPLETWEPAY,APPIAP")
    private String payChannel;
    /**
     * AuthCode
     */
    @ApiModelProperty(position = 8, required = true, value = "支付用的AuthCode")
    private String authCode;
    @ApiModelProperty(position = 9, required = true, value = "支付用的productId")
    private String productId;
    @ApiModelProperty(position = 10, required = true, value = "支付用的openId")
    private String openId;

}
