package com.liquidnet.client.admin.zhengzai.smile.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileVTSParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileVolunteersTeamService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.smile.entity.SmileProjectTeamRelation;
import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import com.liquidnet.service.smile.mapper.SmileProjectTeamRelationMapper;
import com.liquidnet.service.smile.mapper.SmileVolunteersTeamMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class SmileVolunteersTeamServiceImpl extends ServiceImpl<SmileVolunteersTeamMapper, SmileVolunteersTeam> implements ISmileVolunteersTeamService {

    @Autowired
    SmileVolunteersTeamMapper volunteersTeamMapper;
    @Autowired
    SmileProjectTeamRelationMapper projectTeamRelationMapper;
    @Autowired
    SmileRedisUtils redisUtils;

    @Override
    public  List<SmileVolunteersTeam> list(SmileVTSParam param) {
        try {
            TableDataInfo rspData = new TableDataInfo();
            LambdaQueryWrapper<SmileVolunteersTeam> wrappers = Wrappers.lambdaQuery(SmileVolunteersTeam.class);
            if (param.getTitle() != null && !param.getTitle().equals("")) {
                wrappers.like(SmileVolunteersTeam::getName, param.getTitle());
            }
            wrappers.orderByDesc(SmileVolunteersTeam::getCreatedAt);
            List<SmileVolunteersTeam> data = volunteersTeamMapper.selectList(wrappers);
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AjaxResult insertData(SmileVolunteersTeam bean) {
        LambdaQueryWrapper<SmileVolunteersTeam> wrappers = Wrappers.lambdaQuery(SmileVolunteersTeam.class);
        wrappers.eq(SmileVolunteersTeam::getName, bean.getName());
        List<SmileVolunteersTeam> dataList = volunteersTeamMapper.selectList(wrappers);
        if (dataList.size() > 0) {
            return AjaxResult.error("职责组名称重复");
        }
        bean.setTeamId(IDGenerator.nextTimeId2());
        int count = volunteersTeamMapper.insert(bean);
        if (count > 0) {
            redisUtils.setTeam(bean.getTeamId(), bean);
            return AjaxResult.success("添加成功");
        }
        return AjaxResult.error("添加失败");
    }

    @Override
    public AjaxResult updateData(SmileVolunteersTeam bean) {
        LambdaQueryWrapper<SmileVolunteersTeam> wrappers = Wrappers.lambdaQuery(SmileVolunteersTeam.class);
        wrappers.eq(SmileVolunteersTeam::getName, bean.getName());
        List<SmileVolunteersTeam> dataList = volunteersTeamMapper.selectList(wrappers);
        for (SmileVolunteersTeam data : dataList) {
            if (!data.getTeamId().equals(bean.getTeamId()) && data.getName().equals(bean.getName())) {
                return AjaxResult.error("职责组名称重复不可修改");
            }
        }
        bean.setUpdatedAt(LocalDateTime.now());
        int count = volunteersTeamMapper.update(bean, Wrappers.lambdaQuery(SmileVolunteersTeam.class).eq(SmileVolunteersTeam::getTeamId, bean.getTeamId()));
        if (count > 0) {
            redisUtils.setTeam(bean.getTeamId(), bean);
            return AjaxResult.success("修改成功");
        }
        return AjaxResult.error("修改失败");
    }

    @Override
    public SmileVolunteersTeam details(String teamId) {
        LambdaQueryWrapper<SmileVolunteersTeam> wrappers = Wrappers.lambdaQuery(SmileVolunteersTeam.class);
        wrappers.eq(SmileVolunteersTeam::getTeamId, teamId);
        SmileVolunteersTeam data = volunteersTeamMapper.selectOne(wrappers);
        return data;
    }

    @Override
    public AjaxResult search(String title) {
        LambdaQueryWrapper<SmileVolunteersTeam> wrappers = Wrappers.lambdaQuery(SmileVolunteersTeam.class);
        wrappers.select(SmileVolunteersTeam::getTeamId, SmileVolunteersTeam::getName, SmileVolunteersTeam::getIntroduce);
        wrappers.like(SmileVolunteersTeam::getName, title);
        List<SmileVolunteersTeam> beanList = volunteersTeamMapper.selectList(wrappers);
        AjaxResult ajax = new AjaxResult();
        ajax.put("value", beanList);
        return ajax;
    }

    @Override
    public AjaxResult getListByProjectId(String projectId) {
        //获取 活动 组 关系
        List<String> teamIdList = projectTeamRelationMapper.selectList(Wrappers.lambdaQuery(SmileProjectTeamRelation.class).eq(SmileProjectTeamRelation::getProjectId, projectId)).stream().map(SmileProjectTeamRelation::getTeamId).collect(Collectors.toList());
        //获取 关联组详情
        List<SmileVolunteersTeam> beanList = volunteersTeamMapper.selectList(Wrappers.lambdaQuery(SmileVolunteersTeam.class).in(SmileVolunteersTeam::getTeamId, teamIdList));
        AjaxResult ajax = new AjaxResult();
        ajax.put("value", beanList);
        return ajax;
    }
}
