package com.liquidnet.common.third.xuper.config;

import com.baidu.xasset.client.xasset.Asset;
import com.baidu.xasset.common.config.Config;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.logging.Logger;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: Xuper配置
 * @class: XuperConfig
 * @Package com.liquidnet.common.third.xuper.config
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 17:42
 */
@Slf4j
@Configuration
public class XuperConfig {
    @Value("${liquidnet.service.galaxy.xuper.appId:110381}")
    private String appId;
    @Value("${liquidnet.service.galaxy.xuper.accessKeyID:f3565df21f2b84d999dd7e2817ed80ea}")
    private String accessKeyID;
    @Value("${liquidnet.service.galaxy.xuper.secretAccessKey:b2ee53f6bb5555ee3582198fd52552cc}")
    private String secretAccessKey;
    @Value("${liquidnet.service.galaxy.xuper.nftApiUrl:http://120.48.16.137:8360}")
    private String nftApiUrl;
    @Value("${liquidnet.service.galaxy.xuper.nftPlatformMnemonic}")
    private String nftPlatformMnemonic;
    @Value("${liquidnet.service.galaxy.xuper.nftPlatformAddress}")
    private String nftPlatformAddress;

    private Asset asset = null;
    private static Asset staticAsset = null;

    private static Logger logger = Logger.getLogger(XuperConfig.class.getCanonicalName());

    @PostConstruct
    public void init(){
        long _appId = Long.parseLong(appId);
        String ak = accessKeyID;
        String sk = secretAccessKey;
//        //测试环境
//        String ak2 = MD5Utils.md5(accessKeyID);
//        String sk2 = MD5Utils.md5(secretAccessKey);
//        System.out.println("test==ak=="+ak2);
//        System.out.println("test==sk=="+sk2);
        Config.XassetCliConfig cfg = new Config.XassetCliConfig();
        cfg.setCredentials(_appId, ak, sk);
        cfg.setEndPoint(nftApiUrl);

        // 初始化接口类
//        Logger logger = Logger.getGlobal();
//        logger.getParent().setLevel(Level.INFO);
        log.info("logger.getParent().getLevel() === {}",logger.getParent().getLevel());
//        logger.setLevel(Level.INFO);
        log.info("logger.getLevel() === {}",logger.getLevel());
        asset = new Asset(cfg, logger);
    }
//
//    static{
//        long appId = 1182282645;
//        String ak = "";
//        String sk = "";
//        String apiUrl = "http://120.48.16.137:8360";
//
//        Config.XassetCliConfig cfg = new Config.XassetCliConfig();
//        cfg.setCredentials(appId, ak, sk);
//        cfg.setEndPoint(apiUrl);
//
//        // 初始化接口类
//        staticAsset = new Asset(cfg, Logger.getGlobal());
//    }

    public Asset getAsset(){
        return this.asset;
    }

    public String getAppId() {
        return appId;
    }

    public String getAccessKeyID() {
        return accessKeyID;
    }

    public String getSecretAccessKey() {
        return secretAccessKey;
    }

    public String getNftApiUrl() {
        return nftApiUrl;
    }

    public String getNftPlatformMnemonic() {
        return nftPlatformMnemonic;
    }

    public String getNftPlatformAddress() {
        return nftPlatformAddress;
    }
}
