package com.liquidnet.service.feign.adam.rsc;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-chime",
        contextId = "FeignAdamChimeClient", path = "chime",
        url = "${liquidnet.service.chime.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignAdamChimeClient {

    @PostMapping("user/register")
    ResponseDto<String> registerForUser(@RequestParam(value = "userId") String userId,
                                        @RequestParam(value = "sex") String sex,
                                        @RequestParam(value = "tags") String tags,
                                        @RequestParam(value = "operateType") String operateType
    );
}
