package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.KylinPerformanceSubscribeTicketStatisticalExportDao;
import com.liquidnet.client.admin.zhengzai.kylin.dto.PerformanceOrderStatisCountResp;
import com.liquidnet.client.admin.zhengzai.kylin.dto.PerformanceTicketSalesDto;
import com.liquidnet.client.admin.zhengzai.kylin.service.IOpenDataService;
import com.liquidnet.client.admin.zhengzai.kylin.utils.DataSumUtils;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dao.PerformanceMemberAuditDao;
import com.liquidnet.service.kylin.dao.PerformanceOrderStatisticalDao;
import com.liquidnet.service.kylin.dao.report.KylinPerformanceSubscribeTicketStatisticalDao;
import com.liquidnet.service.kylin.dto.param.PerformanceAdminListParam;
import com.liquidnet.service.kylin.dto.param.PerformanceMemberAuditParam;
import com.liquidnet.service.kylin.dto.param.SysDamaiParam;
import com.liquidnet.service.kylin.dto.vo.admin.*;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformancesVo;
import com.liquidnet.service.kylin.entity.KylinOrderImport;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import com.liquidnet.service.kylin.service.other.DamaiService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


/**
 * 演出Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/performances")
public class KylinPerformancesController extends BaseController {
    private String prefix = "zhengzai/kylin/performances";

    @Autowired
    private IKylinPerformancesAdminService kylinPerformancesService;

    @Autowired
    private DamaiService damaiService;
    @Autowired
    private IOpenDataService openDataService;

    //@RequiresPermissions("kylin:performances:view")
    @GetMapping()
    public String performances() {
        return prefix + "/performances";
    }

    @GetMapping(value = "/test")
    public void test() {
        kylinPerformancesService.test();
    }

    @Log(title = "同步票务平台-演出", businessType = BusinessType.OTHER)
    @PostMapping(value = "/syncTicketSysPerformance")
    @ResponseBody
    public AjaxResult syncTicketSysPerformance(@RequestParam("performancesId") String performancesId) {
        boolean result = kylinPerformancesService.syncTicketSysPerformance(performancesId);
        return toAjax(result);
    }

    @Log(title = "同步票务平台-订单", businessType = BusinessType.OTHER)
    @PostMapping(value = "/syncTicketSysOrder")
    @ResponseBody
    public AjaxResult syncTicketSysOrder(@RequestParam("performancesId") String performancesId) {
        boolean result = kylinPerformancesService.syncTicketSysOrder(performancesId);
        return toAjax(result);
    }

    /**
     * 查询演出列表
     */
    //@RequiresPermissions("kylin:performances:view")
    @Log(title = "演出列表", businessType = BusinessType.LIST)
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(PerformanceAdminListParam performanceAdminListParam) {
        PageInfo<PerformanceAdminListDao> result = kylinPerformancesService.getList(performanceAdminListParam);
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(result.getList());
        rspData.setTotal(result.getTotal());
        return rspData;
    }

    //@RequiresPermissions("kylin:performances:view")
    @Log(title = "演出列表", businessType = BusinessType.DETAIL)
    @GetMapping(value = "/details/{performancesId}")
    public String performanceDetails(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        KylinPerformanceMisVo result = null;
        result = kylinPerformancesService.performanceDetails(performancesId);
        mmap.put("kylinPerformanceMisVo", result);
        return prefix + "/details";
    }

    @Log(title = "演出审核", businessType = BusinessType.AUDIT)
    @PostMapping(value = "/audit")
    //@RequiresPermissions("kylin:performances:view")
    @ResponseBody
    public AjaxResult performanceAudit(@RequestParam("performancesId") String performancesId, @RequestParam("status") int status, @RequestParam(value = "rejectTxt", required = false) String rejectTxt) {
        boolean result = kylinPerformancesService.performanceAudit(performancesId, status, rejectTxt);
        return toAjax(result);
    }

    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/isShow")
    @ResponseBody
    @Log(title = "演出管理：是否显示", businessType = BusinessType.PERFORMANCE_SAVE)
    public AjaxResult setIsShow(String performancesId, Integer isShow) {
        return toAjax(kylinPerformancesService.setIsShow(performancesId, isShow));
    }

    //    @Log(title = "演出列表", businessType = BusinessType.DETAIL)
    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/memberInfo/{performancesId}")
    public String memberInfo(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        PerformanceMemberAuditDao result = kylinPerformancesService.performanceMemberInfo(performancesId);
        mmap.put("performanceMemberAuditDao", result);
        return prefix + "/memberInfo";
    }

    @Log(title = "演出管理：提交会员信息", businessType = BusinessType.PERFORMANCE_SAVE)
    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/memberInfo/submit")
    @ResponseBody
    public AjaxResult memberInfo(PerformanceMemberAuditParam performanceMemberAuditParam) {
        boolean result = kylinPerformancesService.performanceMemberChange(performanceMemberAuditParam);
        return toAjax(result);
    }

    //    @Log(title = "演出列表-演出数据", businessType = BusinessType.LIST)
    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/performanceStatic/{performancesId}")
    public String performanceStatic(@PathVariable("performancesId") String performancesId, ModelMap mmap) {

        PerformanceOrderStatisCountResp perCountResp = new PerformanceOrderStatisCountResp();
        List<PerformanceOrderStatisticalDao> result = new ArrayList<>();

        PerformanceTicketSalesDto ticketSalesInfo = openDataService.getPerformanceTicketSalesInfo(performancesId);
        if (ticketSalesInfo != null) {
            perCountResp.setPerformanceTitle(ticketSalesInfo.getPerformanceTitle());
            perCountResp.setTotalSalePrice(new BigDecimal(ticketSalesInfo.getFullSalesAmountTotal()));
            perCountResp.setSaleGeneral(new BigDecimal(ticketSalesInfo.getFullAudienceTicketTotal()));
            perCountResp.setTotalGeneral(new BigDecimal(ticketSalesInfo.getFullTotalGeneral()));
            perCountResp.setTotalRefundGeneral(new BigDecimal(ticketSalesInfo.getFullRefundTicketTotal()));
            perCountResp.setTotalBuyUsers(new BigDecimal(ticketSalesInfo.getFullBuyTotal()));

            List<PerformanceTicketSalesDto.TicketSales> fullTicketDataList = ticketSalesInfo.getFullTicketDataList();
            if (!fullTicketDataList.isEmpty()) {
                for (PerformanceTicketSalesDto.TicketSales ticketSales : fullTicketDataList) {
                    PerformanceOrderStatisticalDao statisticalDao = new PerformanceOrderStatisticalDao();
                    statisticalDao.setPerformancesId(ticketSalesInfo.getPerformanceId());
                    statisticalDao.setTicketsId(ticketSales.getTicketId());
                    statisticalDao.setTitle(ticketSales.getTicketTitle());
                    statisticalDao.setPrice(new BigDecimal(ticketSales.getTicketPrice()));
                    statisticalDao.setType(ticketSales.getTicketType());
                    statisticalDao.setTotalGeneral(new BigDecimal(ticketSales.getTotalGeneral()));
                    statisticalDao.setSaleGeneral(new BigDecimal(ticketSales.getAudienceTicketTotal()));
                    statisticalDao.setTotalRefundGeneral(new BigDecimal(ticketSales.getRefundTicketTotal()));
                    statisticalDao.setTotalPayingNumber(new BigDecimal(ticketSales.getPayingTotal()));
                    statisticalDao.setTimeId(ticketSales.getTimeId());
                    statisticalDao.setTimeTitle(ticketSales.getTimeTitle());
                    statisticalDao.setVipBuyTotal(ticketSales.getVipBuyTotal());
                    statisticalDao.setFullRefundTicketTotal(ticketSales.getFullRefundTicketTotal());
                    statisticalDao.setHandlingFeeRefundTicketTotal(ticketSales.getHandlingFeeRefundTicketTotal());
                    statisticalDao.setRefundFeeRevenueTotal(new BigDecimal(ticketSales.getRefundFeeRevenueTotal()));
                    statisticalDao.setAudienceSalesAmountTotal(new BigDecimal(ticketSales.getAudienceSalesAmountTotal()));
                    statisticalDao.setSurplusGeneral(new BigDecimal(ticketSales.getSurplusGeneral()));
                    result.add(statisticalDao);
                }
            }
        }else {
            //获取演出详情
            KylinPerformanceMisVo performanceMisVo = kylinPerformancesService.performanceDetails(performancesId);

            result = kylinPerformancesService.getPerformanceOrderStatisticalList(performancesId);
            perCountResp.setPerformanceTitle(performanceMisVo.getTitle());
            if (result.size() >= 2) {
                PerformanceOrderStatisticalDao resdao = result.get(result.size() - 1);
                perCountResp.setTotalSalePrice(resdao.getTotalSalePrice());
                perCountResp.setSaleGeneral(resdao.getSaleGeneral());
                perCountResp.setTotalGeneral(resdao.getTotalGeneral());
                perCountResp.setTotalExchange(resdao.getTotalExchange());
                perCountResp.setSurplusExchange(resdao.getSurplusGeneral());
                perCountResp.setTotalBuyUsers(resdao.getTotalBuyUsers());
                perCountResp.setTotalDisPrice(BigDecimal.ONE);
                perCountResp.setTotalRefundGeneral(resdao.getTotalRefundGeneral());
            }
        }

        mmap.put("perCountResp", perCountResp);
        mmap.put("perOrderStaticList", result);
        mmap.put("sumResp", DataSumUtils.sumStatistics(result));
        return prefix + "/performancesStatic";
    }

    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/damai/{performancesId}")
    public String damai(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        KylinPerformanceDamaiVo result = kylinPerformancesService.getPerformanceDamai(performancesId);
        mmap.put("kylinPerformanceDamaiVo", result);
        return prefix + "/damai";
    }

    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/agent/{performancesId}")
    public String agent(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        KylinPerformanceAgentVo result = kylinPerformancesService.getPerformanceAgent(performancesId);
        mmap.put("kylinPerformanceAgentVo", result);
        return prefix + "/agent";
    }

    @GetMapping(value = "/payTxt/{performancesId}")
    public String payTxt(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        KylinPerformancePayTxtVo result = kylinPerformancesService.getPerformancePayTxt(performancesId);
        mmap.put("kylinPerformancePayTxtVo", result);
        return prefix + "/payTxt";
    }
    
    /*
     * @description: 预约统计
     * @author: zjp
     * @date: 2024/9/11 17:03
     * @param: [performancesId, mmap]
     * @return: java.lang.String
     **/
    @GetMapping(value = "/subscribe/{performancesId}")
    public String subscribe(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        List<KylinPerformanceSubscribeTicketStatisticalDao> result = kylinPerformancesService.getPerformanceSubscribe(performancesId);
        mmap.put("subscribeStaticList", result);
        mmap.put("performancesId",performancesId);
        return prefix + "/subscribe";
    }

    @Log(title = "预约统计:导出列表")
    @PostMapping("/subscribe/export")
    @ResponseBody
    public AjaxResult subscribeExport(@RequestParam("performancesId") String performancesId) {
        List<KylinPerformanceSubscribeTicketStatisticalDao> list = kylinPerformancesService.getPerformanceSubscribe(performancesId);
        ArrayList<KylinPerformanceSubscribeTicketStatisticalExportDao> listExport = new ArrayList<>();
        for (KylinPerformanceSubscribeTicketStatisticalDao kylinPerformanceSubscribeTicketStatisticalDao : list) {
            KylinPerformanceSubscribeTicketStatisticalExportDao kylinPerformanceSubscribeTicketStatisticalExportDao = new KylinPerformanceSubscribeTicketStatisticalExportDao();
            kylinPerformanceSubscribeTicketStatisticalExportDao.setTimeTitle(kylinPerformanceSubscribeTicketStatisticalDao.getTimeTitle());
            kylinPerformanceSubscribeTicketStatisticalExportDao.setTicketTimesTitle(kylinPerformanceSubscribeTicketStatisticalDao.getTicketTimesTitle());
            kylinPerformanceSubscribeTicketStatisticalExportDao.setSubscribeTotal(kylinPerformanceSubscribeTicketStatisticalDao.getSubscribeTotal());
            listExport.add(kylinPerformanceSubscribeTicketStatisticalExportDao);
        }
        ExcelUtil<KylinPerformanceSubscribeTicketStatisticalExportDao>  util = new ExcelUtil(KylinPerformanceSubscribeTicketStatisticalExportDao.class);
        return util.exportExcel(listExport, "预约统计");
    }
    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/agent/change")
    @ResponseBody
    @Log(title = "演出管理：票种代理", businessType = BusinessType.PERFORMANCE_SAVE)
    public AjaxResult changeTicketAgent(@RequestParam("performancesId") String performancesId, @RequestParam("ticketsId") String ticketsId, @RequestParam("status") Integer status) {
        boolean result = kylinPerformancesService.changeTicketAgent(performancesId, ticketsId, status);
        return toAjax(result);
    }

    @PostMapping(value = "/payTxt/change")
    @ResponseBody
    @Log(title = "演出管理：支付文案", businessType = BusinessType.PERFORMANCE_SAVE)
    public AjaxResult changeTicketPayTxt(@RequestParam("performancesId") String performancesId, @RequestParam("ticketsId") String ticketsId, @RequestParam("payTxt") String payTxt) {
        boolean result = kylinPerformancesService.changeTicketPayTxt(performancesId, ticketsId, payTxt);
        return toAjax(result);
    }

    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/damai/change")
    @ResponseBody
    public AjaxResult changeSysDamai(@RequestParam("params") String params) {
        List<SysDamaiParam> data = JsonUtils.fromJson(params, new TypeReference<List<SysDamaiParam>>() {
        });
        boolean result = kylinPerformancesService.changeSysDamai(data);
        return toAjax(result);
    }

    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/sync/damai")
    @ResponseBody
    public AjaxResult syncDamai(@RequestParam("performancesId") String performancesId) {
        boolean result = damaiService.sycPerformance(performancesId);
        return toAjax(result);
    }

    //@RequiresPermissions("kylin:performances:view")
    @GetMapping(value = "/refundConfig/{performancesId}")
    public String getRefundConfig(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        PerformanceRefundConfigVo result = kylinPerformancesService.getRefundConfig(performancesId);
        mmap.put("performanceRefundConfigVo", result);
        return prefix + "/refundConfig";
    }

    @GetMapping(value = "/refundPoundage/{performancesId}")
    public String getRefundPoundage(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        ArrayList<OrderRefundPoundage> refundPoundageList = kylinPerformancesService.getRefundPoundageAll(performancesId);
        String refundPoundageExplain = kylinPerformancesService.getPoundageExplain(performancesId);
        mmap.put("performancesId", performancesId);
        mmap.put("refundPoundageList", refundPoundageList);
        mmap.put("refundPoundageExplain", refundPoundageExplain);
        return prefix + "/refundPoundage";
    }

    //
    @PostMapping(value = "/refundConfig/explain") //todo 阶梯退票
    @ApiOperation(value = "设置注意事项")
    @ResponseBody
    public AjaxResult setPoundageExplain(@RequestParam("explain") String explain,
                                         @RequestParam("performancesId") String performancesId) {
        String result = kylinPerformancesService.setPoundageExplain(explain, performancesId);
        return AjaxResult.success(result);
    }

    @GetMapping(value = "/refundConfig/explain") //todo 阶梯退票
    @ApiOperation(value = "获取注意事项")
    @ResponseBody
    public AjaxResult getPoundageExplain(@RequestParam("performancesId") String performancesId) {
        String result = kylinPerformancesService.getPoundageExplain(performancesId);
        return AjaxResult.success(result);
    }

    //阶梯退票
    @GetMapping(value = "/refundConfig/poundage") //todo 阶梯退票
    @ApiOperation(value = "获取阶梯退票")
    @ResponseBody
    public AjaxResult getRefundPoundageAll(@RequestParam("performancesId") String performancesId) {
        ArrayList<OrderRefundPoundage> result = kylinPerformancesService.getRefundPoundageAll(performancesId);
        return AjaxResult.success(result);
    }

    //
    @PostMapping(value = "/refundConfig/poundage") //todo 阶梯退票
    @ApiOperation(value = "设置阶梯退票")
    @ResponseBody
    public AjaxResult setRefundPoundageAll(@RequestBody OrderRefundPoundageF param) {
        String result = kylinPerformancesService.setRefundPoundageAll(param.getOrderRefundPoundage(), param.getPerformanceId());
        if (null != result && result.equals("操作成功")) {
            return AjaxResult.success(result);
        } else {
            return AjaxResult.error(result);
        }
    }

    //@RequiresPermissions("kylin:performances:view")
    @PostMapping(value = "/refundConfig/change")
    @ResponseBody
    @Log(title = "演出管理：退款配置", businessType = BusinessType.PERFORMANCE_SAVE)
    public AjaxResult changeRefundConfig(@RequestParam("performancesId") String performancesId,
                                         @RequestParam("isCanRefund") Integer isCanRefund,
                                         @RequestParam("refundOpenTime") String refundOpenTime,
                                         @RequestParam("refundCloseTime") String refundCloseTime,
                                         @RequestParam("isRefundPoundage") Integer isRefundPoundage,
                                         @RequestParam("isRefundVoucher") Integer isRefundVoucher,
                                         @RequestParam("isRefundExpress") Integer isRefundExpress,
                                         @RequestParam("isBackPaperTicket") Integer isBackPaperTicket,
                                         @RequestParam("isRefundExpressNew") Integer isRefundExpressNew) {
        String result = kylinPerformancesService.changeRefundConfig(performancesId, isCanRefund, refundOpenTime, refundCloseTime, isRefundPoundage, isRefundVoucher, isRefundExpress, isBackPaperTicket, isRefundExpressNew);
        return this.success(result);
    }

    @GetMapping(value = "/transferConfig/{performancesId}")
    public String getTransferConfig(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        PerformanceTransferConfigVo result = kylinPerformancesService.getTransferConfig(performancesId);
        mmap.put("performanceTransferConfigVo", result);
        return prefix + "/transferConfig";
    }

    @GetMapping(value = "/orderImport/{performancesId}")
    public String getOrderImport(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        mmap.put("performancesId", performancesId);
        return prefix + "/orderImport";
    }

    @PostMapping(value = "/orderImport/list/{performancesId}")
    @ResponseBody
    public TableDataInfo getOrderImportList(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        startPage();
        List<KylinOrderImport> result = kylinPerformancesService.getOrderImport(performancesId);
        return getDataTable(result);
    }

    @PostMapping(value = "/transferConfig/change")
    @ResponseBody
    @Log(title = "演出管理：转赠配置", businessType = BusinessType.PERFORMANCE_SAVE)
    public AjaxResult changeTransferConfig(@RequestParam("performancesId") String performancesId,
                                           @RequestParam("isCanTransfer") Integer isCanTransfer,
                                           @RequestParam("transferStartTime") String transferStartTime,
                                           @RequestParam("transferEndTime") String transferEndTime) {
        String result = kylinPerformancesService.changeTransferConfig(performancesId, isCanTransfer, transferStartTime, transferEndTime);
        return this.success(result);
    }

    @GetMapping(value = "/search")
    @ResponseBody
    public ResponseDto<List<KylinPerformancesVo>> searchPerformanceByTitle(@RequestParam(value = "title") String title) {
        List<KylinPerformancesVo> kylinPerformancesVoList = kylinPerformancesService.searchPerformanceByTitle(title);
        return ResponseDto.success(kylinPerformancesVoList);
    }
}
