package com.liquidnet.service.platform.controller.adam;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.service.adam.dto.vo.AdamProScanitVo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.service.impl.adam.PlatformAdamUserProService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

@Api(tags = "专业版APP:用户相关")
@Slf4j
@Validated
@RestController
@RequestMapping("pro")
public class PlatformAdamProController {
    @Autowired
    PlatformAdamUserProService platformAdamUserProService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "PRO扫一扫")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "pidco", value = "格式[用户QRCODE@演出ID]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "pname", value = "演出名称"),
    })
    @PostMapping(value = {"scanit"})
    public ResponseDto<AdamProScanitVo> scan(@NotBlank(message = "参数有误") @RequestParam String pidco,
                                                @NotBlank(message = "参数有误") @RequestParam String pname) {
        String[] split = pidco.split("@");
        if (split.length < 2) {
            log.warn("#PRO:SCANIT[pidco={},pname={}]", pidco, pname);
            return ResponseDto.failure(ErrorCode.HTTP_PARAM_ERROR.getMessage());
        }
        log.info("PRO:SCANIT[pidco={},pname={}]", pidco, pname);
        return ResponseDto.success(platformAdamUserProService.scanitProcess(split[1], pname, split[0]).desensitize());
    }
}
