package com.liquidnet.service.sweet.dto.param.admin;

import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * SweetIntegralActivityFromParam
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */

@Data
@ApiModel(value = "SweetIntegralActivityFromParam", description = "积分活动创建活动入参")
public class SweetIntegralActivityFromParam implements Serializable, Cloneable {

    private static final long serialVersionUID = -648510827144997014L;

    @ApiModelProperty(value = "活动id[创建不传]", example = "1")
    private String integralActivityId;

    @ApiModelProperty(required = true, value = "活动名称")
    private String activityTitle;

    @ApiModelProperty(required = true, value = "活动图片")
    private String activityImg;

    @ApiModelProperty(required = true, value = "活动类型 1转盘")
    private Integer activityType;

    @ApiModelProperty(required = true, value = "活动时间类型 1长期 2开始结束时间")
    private Integer timeType;

    @ApiModelProperty(value = "如果活动有时间限制 开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "如果活动有时间限制 结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(required = true, value = "快递费用类型 1包邮 2到付")
    private Integer expressFeeType;

    @ApiModelProperty(required = true, value = "活动规则")
    private String activityRules;

    @ApiModelProperty(required = true, value = "是否上线 1未上线 2已上线")
    private Integer isOnline;

    @ApiModelProperty(value = "奖品列表")
    private List<SweetIntegralActivityPrizeFormParam> prizeList;

    private static final SweetIntegralActivityFromParam obj = new SweetIntegralActivityFromParam();

    public static SweetIntegralActivityFromParam getNew() {
        try {
            return (SweetIntegralActivityFromParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityFromParam();
        }
    }

    public SweetIntegralActivity copy(SweetIntegralActivityFromParam source) {
        SweetIntegralActivity sweetIntegralActivity = SweetIntegralActivity.getNew();
        if (null == source) return null;
        sweetIntegralActivity.setIntegralActivityId(source.getIntegralActivityId());
        sweetIntegralActivity.setActivityTitle(source.getActivityTitle());
        sweetIntegralActivity.setActivityImg(source.getActivityImg());
        sweetIntegralActivity.setActivityType(source.getActivityType());
        sweetIntegralActivity.setStartTime(source.getStartTime());
        sweetIntegralActivity.setEndTime(source.getEndTime());
        sweetIntegralActivity.setExpressFeeType(source.getExpressFeeType());
        sweetIntegralActivity.setActivityRules(source.getActivityRules());
        sweetIntegralActivity.setIsOnline(source.getIsOnline());
        return sweetIntegralActivity;
    }

}