package com.liquidnet.service.sweet.dto.param.admin;

import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * SweetIntegralActivityPrizeFormParam
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-21
 */

@Data
@ApiModel(value = "SweetIntegralActivityPrizeFormParam", description = "积分活动创建奖品入参")
public class SweetIntegralActivityPrizeFormParam implements Serializable,Cloneable {

    private static final long serialVersionUID = 9194454546358707259L;

    @ApiModelProperty(value = "奖品id 创建不传", example = "")
    private String prizeId;

    @ApiModelProperty(value = "活动id[创建不传]", example = "1")
    private String integralActivityId;

    @ApiModelProperty(required = true, value = "奖品名称", example = "")
    private String prizeTitle;

    @ApiModelProperty(required = true, value = "奖品图片", example = "")
    private String prizeImg;

    @ApiModelProperty(required = true, value = "奖品类型 1谢谢惠顾 2积分 3优惠券 4实物", example = "")
    private Integer prizeType;

    @ApiModelProperty(value = "关联id 如商品id 券id", example = "")
    private String relationId;

    @ApiModelProperty(required = true, value = "奖品数量", example = "")
    private Integer prizeNum;

    @ApiModelProperty(required = true, value = "限制的中奖人数", example = "")
    private Integer winnersNum;

    @ApiModelProperty(required = true, value = "中奖概率", example = "")
    private BigDecimal winningProbability;

    private static final SweetIntegralActivityPrizeFormParam obj = new SweetIntegralActivityPrizeFormParam();

    public static SweetIntegralActivityPrizeFormParam getNew() {
        try {
            return (SweetIntegralActivityPrizeFormParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityPrizeFormParam();
        }
    }

    public SweetIntegralActivityPrize copy(SweetIntegralActivityPrizeFormParam source) {
        SweetIntegralActivityPrize sweetIntegralActivityPrize = SweetIntegralActivityPrize.getNew();
        if (null == source) return null;
        sweetIntegralActivityPrize.setIntegralActivityId(source.getIntegralActivityId());
        sweetIntegralActivityPrize.setPrizeId(source.getPrizeId());
        sweetIntegralActivityPrize.setPrizeTitle(source.getPrizeTitle());
        sweetIntegralActivityPrize.setPrizeImg(source.getPrizeImg());
        sweetIntegralActivityPrize.setPrizeType(source.getPrizeType());
        sweetIntegralActivityPrize.setRelationId(source.getRelationId());
        sweetIntegralActivityPrize.setPrizeNum(source.getPrizeNum());
        sweetIntegralActivityPrize.setWinnersNum(source.getWinnersNum());
        sweetIntegralActivityPrize.setWinningProbability(source.getWinningProbability());
        return sweetIntegralActivityPrize;
    }

}
