package com.liquidnet.service.goblin.dto.manage.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinMgtCategorySpecVo", description = "分类关联的规格信息")
@Data
public class GoblinMgtCategorySpecVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -1807588898644126000L;
    @ApiModelProperty(position = 11, value = "分类ID")
    private String cateId;
    @ApiModelProperty(position = 12, value = "规格ID")
    private String specId;
    @ApiModelProperty(position = 13, value = "规格名称")
    private String specName;
    @ApiModelProperty(position = 14, value = "删除标记[0-未删除|1-删除")
    private String delFlg;

    private static final GoblinMgtCategorySpecVo obj = new GoblinMgtCategorySpecVo();
    public static GoblinMgtCategorySpecVo getNew() {
        try {
            return (GoblinMgtCategorySpecVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMgtCategorySpecVo();
        }
    }
}
