package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel
public class GoblinUseResultVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 4073256621782131607L;
    @ApiModelProperty(value = "优惠内容", example = "1")
    private BigDecimal value;
    @ApiModelProperty(value = "券类型[1-代金券|2-折扣券|3-满减券]", example = "1")
    private String couType;
    @ApiModelProperty(value = "适用spu范围")
    private List<String> spuIds;

    private static final GoblinUseResultVo obj = new GoblinUseResultVo();

    public static GoblinUseResultVo getNew() {
        try {
            return (GoblinUseResultVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinUseResultVo();
    }

}
