package com.liquidnet.service.smile.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ToString
public class SmileUser implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private String uid;

    /**
     * 照片
     */
    private String img;

    /**
     * 真实姓名
     */
    private String name;

    /**
     * 生日YYYY-MM-DD
     */
    private LocalDate birthday;

    /**
     * 性别(1：男（默认），2：女)
     */
    private Integer sex;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 省Id
     */
    private String provinceId;

    /**
     * 省
     */
    private String province;

    /**
     * 市Id
     */
    private String cityId;

    /**
     * 市
     */
    private String city;

    /**
     * 区Id
     */
    private String areaId;

    /**
     * 区
     */
    private String area;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 微信号
     */
    private String wechat;

    /**
     * 代理类型（0：未审核，1：总代，2：普代，3：未认证）
     */
    private Integer type;

    /**
     * 组织关联
     */
    private Long orgId;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 学校ID
     */
    private String schoolId;

    /**
     * 学校名称
     */
    private String schoolName;

    /**
     * 专业
     */
    private String schoolMajor;

    /**
     * 身份（1:在校学生（默认），2已毕业）
     */
    private Integer identity;

    /**
     * 标识步骤
     */
    private String tag;

    /**
     * 认证失败原因
     */
    private String errorReason;

    /**
     * 1：代理开启，2：代理关闭
     */
    private Integer agent;

    /**
     * 组织总代id
     */
    private String agentId;

    /**
     * 自我介绍
     */
    private String introduce;

    /**
     * 擅长1
     */
    private String specialty1;

    /**
     * 擅长2
     */
    private String specialty2;

    /**
     * 擅长3
     */
    private String specialty3;

    /**
     * 正常/黑名单
     */
    private Integer state;

    /**
     * 0：未删除，1：已删除
     */
    private Integer delTag;

    private LocalDateTime createdDate;

    private LocalDateTime updatedDate;

}
