package com.liquidnet.client.admin.zhengzai.kylin.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrderExportVo implements Serializable, Cloneable{
    @Excel(name = "演出名称", cellType = Excel.ColumnType.STRING)
    private String performanceTitle;
    @Excel(name = "手机号", cellType = Excel.ColumnType.STRING)
    private String userMobile;
    @Excel(name = "姓名", cellType = Excel.ColumnType.STRING)
    private String userName;

    @Excel(name = "票种名称", cellType = Excel.ColumnType.STRING)
    private String title;
    @Excel(name = "票种适用时间", cellType = Excel.ColumnType.STRING)
    private String useTime;
    @Excel(name = "票种适用开始时间", cellType = Excel.ColumnType.STRING)
    private String useStart;
    @Excel(name = "票种适用结束时间", cellType = Excel.ColumnType.STRING)
    private String useEnd;

    private static final OrderExportVo obj = new OrderExportVo();

    public static OrderExportVo getNew() {
        try {
            return (OrderExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new OrderExportVo();
    }

    public OrderExportVo copyOrderExportVo(OrderExportDao source) {
        this.setPerformanceTitle(source.getPerformanceTitle());
        this.setUserMobile(source.getUserMobile());
        this.setUserName(source.getUserName());
        this.setTitle(source.getTitle());
        this.setUseTime(source.getUseTime());
        this.setUseStart(source.getUseStart());
        this.setUseEnd(source.getUseEnd());
        return this;
    }
}
