package com.liquidnet.service.base;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.liquidnet.commons.lang.util.JsonUtils;

import java.io.Serializable;

public class SmsMessage implements Serializable, Cloneable {
    private static final long serialVersionUID = 8484332083582497676L;
    private String phone;
    private String signName;
    private String templateCode;
    private ObjectNode templateParam;

    public SmsMessage() {
    }

    public SmsMessage(String json) {
        SmsMessage smsMessage = JsonUtils.fromJson(json, SmsMessage.class);
        this.phone = smsMessage.getPhone();
        this.signName = smsMessage.getSignName();
        this.templateCode = smsMessage.getTemplateCode();
        this.templateParam = smsMessage.getTemplateParam();
    }

    public String getPhone() {
        return phone;
    }

    public String getSignName() {
        return signName;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public ObjectNode getTemplateParam() {
        return templateParam;
    }

    private final static SmsMessage instance = new SmsMessage();

    public static SmsMessage builder() {
        return instance.clone();
    }

    @Override
    public SmsMessage clone() {
        try {
            return (SmsMessage) super.clone();
        } catch (CloneNotSupportedException e) {
            return new SmsMessage();
        }
    }

    public SmsMessage setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public SmsMessage setSignName(String signName) {
        this.signName = signName;
        return this;
    }

    public SmsMessage setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
        return this;
    }

    public SmsMessage setTemplateParam(String key, String val) {
        if (null == this.templateParam) {
            this.templateParam = JsonUtils.OM().createObjectNode();
        }
        this.templateParam.put(key, val);
        return this;
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }
}
