package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberCodeAdminVo", description = "会员码兑换")
@Data
public class AdamMemberCodeVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -2822442493419088086L;
    @ApiModelProperty(position = 0, value = "会员码")
    private String code;
    @ApiModelProperty(position = 1, value = "会员类型id")
    private String memberId;
    @ApiModelProperty(position = 2, value = "会员价格id")
    private String memberPriceId;
    @ApiModelProperty(position = 3, value = "会员码类型0购买1后台生成")
    private String type;
    @ApiModelProperty(position = 4, value = "会员编号")
    private String memberNo;
    @ApiModelProperty(position = 5, value = "状态:0-未使用,1-已使用,2-不可用")
    private int state;
    @ApiModelProperty(position = 6, value = "购买会员码的订单编号")
    private String buyOrderNo;
    @ApiModelProperty(position = 7, value = "购买会员码的用户id")
    private String buyUid;
    @ApiModelProperty(position = 8, value = "购买时间")
    private String buyAt;
    @ApiModelProperty(position = 9, value = "使用会员码的订单编号")
    private String useOrderNo;
    @ApiModelProperty(position = 10, value = "使用会员码的用户id")
    private String useUid;
    @ApiModelProperty(position = 11, value = "使用时间")
    private String useAt;
    @ApiModelProperty(position = 12, value = "会员码id")
    private String memberCodeId;

    private String createdAt;
    private String updatedAt;

    private static final AdamMemberCodeVo obj = new AdamMemberCodeVo();

    public static AdamMemberCodeVo getNew() {
        try {
            return (AdamMemberCodeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamMemberCodeVo();
    }
}
