package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.commons.lang.util.SensitizeUtil;
import com.liquidnet.service.adam.entity.AdamAddresses;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamAddressesVo", description = "收获地址")
@Data
public class AdamAddressesVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -3096308044365829079L;
    @ApiModelProperty(position = 10, value = "收获地址ID[64]")
    private String addressesId;
    @ApiModelProperty(position = 11, value = "姓名[30]")
    private String name;
    @ApiModelProperty(position = 12, value = "手机号[11]")
    private String phone;
    @ApiModelProperty(position = 13, value = "省份[30]")
    private String province;
    @ApiModelProperty(position = 14, value = "城市[30]")
    private String city;
    @ApiModelProperty(position = 15, value = "区县[30]")
    private String county;
    @ApiModelProperty(position = 16, value = "详细地址[100]")
    private String address;
    @ApiModelProperty(position = 18, value = "是否为默认:0-否,1-是")
    private Boolean isDefault;

    private static final AdamAddressesVo obj = new AdamAddressesVo();

    public static AdamAddressesVo getNew() {
        try {
            return (AdamAddressesVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamAddressesVo();
    }

    public AdamAddressesVo copy(AdamAddresses source) {
        if (null == source) return this;
        this.setAddressesId(source.getAddressesId());
        this.setName(source.getName());
        this.setPhone(SensitizeUtil.custom(source.getPhone(), 3, 4));
        this.setProvince(source.getProvince());
        this.setCity(source.getCity());
        this.setCounty(source.getCounty());
        this.setAddress(source.getAddress());
        this.setIsDefault(source.getIsDefault());
        return this;
    }
}
