package com.liquidnet.service.kylin.controller.admin;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.BannerDetailsListDao;
import com.liquidnet.service.kylin.dto.param.BannersParam;
import com.liquidnet.service.kylin.dto.param.BannersSearchParam;
import com.liquidnet.service.kylin.dto.vo.BannersVo;
import com.liquidnet.service.kylin.dto.vo.PagerVo;
import com.liquidnet.service.kylin.service.impl.admin.KylinBannersServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 轮播图 后端管理控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-01
 */

@Api(tags = "后端-banner")
@RestController
@RequestMapping("admin/banners")
public class KylinBannersAdminController {

    @Autowired
    private KylinBannersServiceImpl kylinBannersServiceImpl;

    @PostMapping("")
    @ApiOperation("创建banner")
    public ResponseDto<Object> create(@RequestBody @Validated BannersParam bannersParam) {
        Boolean res = kylinBannersServiceImpl.create(bannersParam);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("添加banner失败");
        }
    }

    @PutMapping("")
    @ApiOperation("修改banner")
    public ResponseDto<Object> update(@RequestBody BannersParam bannersParam) {
        boolean res = kylinBannersServiceImpl.update(bannersParam);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("修改banner失败");
        }
    }

    @GetMapping("{bannersId}")
    @ApiOperation("banner详情")
    public ResponseDto<BannersVo> detail(@PathVariable("bannersId") String bannersId) {
        BannersVo result = null;
        result = kylinBannersServiceImpl.detail(bannersId);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取banner详情失败");
        }
    }

    @GetMapping("list")
    @ApiOperation("banner列表")
    public ResponseDto<PagerVo<BannerDetailsListDao>> bannerList(
            @RequestParam(value = "bannersName", defaultValue = "") String bannersName,
            @RequestParam(value = "isOnline", defaultValue = "1") Integer isOnline,
            @RequestParam(value = "promotionType", defaultValue = "") Integer promotionType,
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "size", defaultValue = "10") Integer size
    ) {
        BannersSearchParam bannersSearchParam = new BannersSearchParam();
        bannersSearchParam.setBannersName(bannersName);
        bannersSearchParam.setIsOnline(isOnline);
        bannersSearchParam.setPromotionType(promotionType);
        bannersSearchParam.setPage(page);
        bannersSearchParam.setSize(size);
        List<BannerDetailsListDao> result = kylinBannersServiceImpl.bannerList(bannersSearchParam);
        Long total = kylinBannersServiceImpl.bannerListCount(bannersSearchParam);

        PagerVo<BannerDetailsListDao> pagerVo = new PagerVo();
        pagerVo.setRows(result);
        pagerVo.setTotal(total);

        if (pagerVo.getRows().size() > 0) {
            return ResponseDto.success(pagerVo);
        } else {
            return ResponseDto.failure("获取列表失败");
        }
    }

    @DeleteMapping("{bannersId}")
    @ApiOperation("删除banner")
    public ResponseDto<Object> delete(@PathVariable("bannersId") String bannersId) {
        boolean result = kylinBannersServiceImpl.delete(bannersId);
        if (result) {
            return ResponseDto.success("删除成功");
        } else {
            return ResponseDto.failure("删除失败");
        }
    }

}
