package com.liquidnet.service.feign.bank.api.currencycloud;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcAccountCreateDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcAccountCreateParam;
import com.liquidnet.service.bank.currencycloud.dto.BankCcFundingAccountDto;
import com.liquidnet.service.feign.bank.api.constant.FeignBankConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Service
@FeignClient(name = FeignBankConstant.LIQUIDNET_SERVICE_BANK,
        path = FeignBankConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignBankConstant.CONTEXT_BANK_CC_FUNDING)
public interface FeignBankCcFundingClient {

    @RequestMapping(value = "/bank-cc-funding/get_funding_account", method = RequestMethod.GET)
    ResponseDto<List<BankCcFundingAccountDto>> getFundingAccount(@RequestParam String accountId, @RequestParam String currency);

}
