package com.liquidnet.service.kylin.dto.vo.partner;

import com.liquidnet.service.kylin.dao.report.KylinPerformancesDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 演出
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Data
public class KylinPerformancesVo implements Cloneable {

    /**
     * 演出id
     */
    @ApiModelProperty(value = "演出id")
    private String performancesId;

    /**
     * 演出名
     */
    @ApiModelProperty(value = "演出名")
    private String title;

    /**
     * 城市
     */
    @ApiModelProperty(value = "城市")
    private String cityName;

    /**
     * 总销售数量  -张   saleGeneral
     */
    @ApiModelProperty(value = "总销售数量")
    private BigDecimal open;

    /**
     * 总销售金额  totalSalePrice
     */
    @ApiModelProperty(value = "总销售金额 ")
    private BigDecimal totalSalePrice;

    /**
     * 演出结束时间
     */
    @ApiModelProperty(value = "演出结束时间")
    private LocalDateTime timeEnd;

    /**
     * 演出结束时间
     */
    @ApiModelProperty(value = "演出结束时间")
    private LocalDateTime timeStart;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序")
    private String comment;

    /**
     * 演出状态
     */
    @ApiModelProperty(value = "演出状态")
    private int status;

    /**
     * 上下架标识【1：下架，0：上架】
     */
    @ApiModelProperty(value = "上下架标识【1：下架，0：上架】")
    private int type;

    private static final KylinPerformancesVo obj = new KylinPerformancesVo();
    public static KylinPerformancesVo getNew() {
        try {
            return (KylinPerformancesVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinPerformancesVo();
        }
    }


    public KylinPerformancesVo copyListAll(KylinPerformancesDto kylinPerformancesDto) {
        if (kylinPerformancesDto==null) return null;
        this.performancesId = kylinPerformancesDto.getPerformancesId();
        this.title = kylinPerformancesDto.getTitle();
        this.type = kylinPerformancesDto.getType();
        this.status = kylinPerformancesDto.getStatus();
        return this;
    }
}
