package com.liquidnet.service.dragon.service.impl;

import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.channel.strategy.PayChannelStrategyContext;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.constant.DragonErrorCodeEnum;
import com.liquidnet.service.dragon.dto.DragonOrdersDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.dto.DragonPayOrderQueryRespDto;
import com.liquidnet.service.dragon.service.IDragonOrdersService;
import com.liquidnet.service.dragon.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@Service
public class DragonOrdersServiceImpl implements IDragonOrdersService {
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Autowired
    private PayChannelStrategyContext payChannelStrategyContext;

    @Autowired
    private DataUtils dataUtils;

    @Override
    public ResponseDto<DragonPayBaseRespDto> dragonPay(DragonPayBaseReqDto dragonPayBaseReqDto) {
        //设置支付编号
        dragonPayBaseReqDto.setCode(IDGenerator.payCode());
        log.info("dragon:dragonPay:req:dragonPayBaseReqDto : {}",dragonPayBaseReqDto.toString());
        return payChannelStrategyContext.getStrategy(dragonPayBaseReqDto.getPayType()).dragonPay(dragonPayBaseReqDto);
    }

    @Override
    public String dragonNotify(HttpServletRequest request,String payType,String deviceFrom) {
        return payChannelStrategyContext.getStrategy(payType).dragonNotify(request,payType,deviceFrom);
    }

    @Override
    public DragonPayOrderQueryRespDto checkOrderStatusByCode(String code) {
        DragonOrdersDto ordersDto = dataUtils.getPayOrderByCode(code);
        if(StringUtil.isEmpty(ordersDto)){
            throw new LiquidnetServiceException(DragonErrorCodeEnum.TRADE_ERROR_NOT_EXISTS.getCode(),DragonErrorCodeEnum.TRADE_ERROR_NOT_EXISTS.getMessage());
        }
        //如果已支付 直接返回结果
        if(!ordersDto.getStatus().toString().equals(DragonConstant.PayStatusEnum.STATUS_UNPAID.getCode())){
            DragonPayOrderQueryRespDto queryRespDto = new DragonPayOrderQueryRespDto();
            queryRespDto.setStatus(ordersDto.getStatus());
            queryRespDto.setType(ordersDto.getType());
            queryRespDto.setCode(ordersDto.getCode());
            queryRespDto.setPaymentId(ordersDto.getPaymentId());
            queryRespDto.setOrderCode(ordersDto.getOrderCode());
            queryRespDto.setPrice(ordersDto.getPrice());
            queryRespDto.setPaymentType(ordersDto.getPaymentType());
            return queryRespDto;
        }
        //如果未支付进行三方查询
        String payType = DragonConstant.PayTypeEnum.getEnumByCode(ordersDto.getPaymentType()).getPayType();
        return payChannelStrategyContext.getStrategy(payType).checkOrderStatus(code);
    }

    @Override
    public DragonPayOrderQueryRespDto checkOrderStatusByOrderCode(String orderCode) {
        String code = dataUtils.getCodeByOrderCode(orderCode);
        return this.checkOrderStatusByCode(code);
    }
}
