package com.liquidnet.service.merchant.util;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.ticketSystem.STInsertPerformanceParam;
import com.liquidnet.service.kylin.dto.param.ticketSystem.STInsertTicketPriceParam;
import com.liquidnet.service.kylin.dto.param.ticketSystem.STUpdatePerformanceParam;
import com.liquidnet.service.kylin.dto.param.ticketSystem.STUpdateTimesParam;
import com.liquidnet.service.kylin.dto.vo.middle.KylinBuyNoticeVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.ticketSystem.TicketPriceVo;
import com.liquidnet.service.kylin.dto.vo.ticketSystem.TimesVo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Component
public class InnerUtils {

    @Value("${liquidnet.service.platform.url}")
    private String platform;

    public List<KylinBuyNoticeVo> getBuyNotice() {
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        String resultData = HttpUtil.get(platform + "/platform/partner/buyNotice", null, header);
        ResponseDto<List<KylinBuyNoticeVo>> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<List<KylinBuyNoticeVo>>>() {
        });
        return innerReturnVo.getData();
    }

    public String getBuyNoticeJsonString(List<String> buyNoticeId) {
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        String resultData = HttpUtil.get(platform + "/platform/partner/buyNotice/string?buyNoticeId=" + StringUtils.join(buyNoticeId, ","), null, header);
        ResponseDto<String> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<String>>() {
        });
        return innerReturnVo.getData();
    }

    //上报演出
    public boolean reportP(KylinPerformanceVo vo, String approval, String sponsorId) {
        STInsertPerformanceParam insertPerformanceParam = STInsertPerformanceParam.getNew();
        insertPerformanceParam.setPerformanceId(vo.getPerformancesId());
        insertPerformanceParam.setPerformanceName(vo.getTitle());
        insertPerformanceParam.setApproval(approval);
        insertPerformanceParam.setTypeId(vo.getType() == 101 ? 2002 : 2003);
        insertPerformanceParam.setPosterUrl(vo.getImgPoster());
        insertPerformanceParam.setSponsor(sponsorId);
        //场次相关
        List<TimesVo> timesVos = new ArrayList();
        List<KylinTicketTimesVo> kylinTimeVos = vo.getTicketTimeList();
        for (KylinTicketTimesVo item : kylinTimeVos) {
            TimesVo timesVo = TimesVo.getNew();
            timesVo.setSessionId(item.getTicketTimesId());
            timesVo.setSessionName(item.getTitle());
            timesVo.setHallCode("320412009");//TODO
            timesVo.setSessionStartTime(LocalDateTime.parse(item.getUseStart()));
            timesVo.setSessionStartTime(LocalDateTime.parse(item.getUseEnd()));
            timesVo.setHasSeat(0);
            timesVos.add(timesVo);
        }
        insertPerformanceParam.setSessionList(timesVos);
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        String resultData = HttpUtil.postRaw(platform + "performance/insert", JSON.toJSONString(insertPerformanceParam), header);
        ResponseDto<Boolean> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<Boolean>>() {
        });
        return innerReturnVo.getData();
    }

    //修改上报的演出项目数据
    public boolean updateP(KylinTicketTimesVo vo, String performanceId, String sessionCode) {
        STUpdateTimesParam updateTimesParam = STUpdateTimesParam.getNew();
        updateTimesParam.setSessionId(vo.getTicketTimesId());
        updateTimesParam.setSessionCode(sessionCode);
        updateTimesParam.setSessionName(vo.getTitle());
        updateTimesParam.setSessionStartTime(LocalDateTime.parse(vo.getUseStart()));
        updateTimesParam.setSessionEndTime(LocalDateTime.parse(vo.getUseEnd()));
        updateTimesParam.setHallCode("320412009");//TODO
        updateTimesParam.setHasSeat(0);
        updateTimesParam.setPerformanceId(performanceId);
        updateTimesParam.setSessionStatus(1);
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        String resultData = HttpUtil.postRaw(platform + "performance/update", JSON.toJSONString(updateTimesParam), header);
        ResponseDto<Boolean> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<Boolean>>() {
        });
        return innerReturnVo.getData();
    }

    //更新上报的场次数据
    public boolean updateTT(KylinPerformanceVo vo, String approval, String sponsorId) {
        STUpdatePerformanceParam updatePerformanceParam = STUpdatePerformanceParam.getNew();
        updatePerformanceParam.setPerformanceId(vo.getPerformancesId());
        updatePerformanceParam.setPerformanceName(vo.getTitle());
        updatePerformanceParam.setTypeId(vo.getType() == 101 ? 2002 : 2003);
        updatePerformanceParam.setPosterUrl(vo.getImgPoster());
        updatePerformanceParam.setSponsor(sponsorId);
        updatePerformanceParam.setApproval(approval);
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        String resultData = HttpUtil.postRaw(platform + "times/update", JSON.toJSONString(updatePerformanceParam), header);
        ResponseDto<Boolean> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<Boolean>>() {
        });
        return innerReturnVo.getData();
    }

    //上报票价信息
    public boolean reportTP(List<KylinTicketVo> vo, String sessionCode,String performanceId,String ticketTimeId) {
        STInsertTicketPriceParam insertTicketPriceParam = STInsertTicketPriceParam.getNew();
        insertTicketPriceParam.setSessionCode(sessionCode);
        List<TicketPriceVo> priceVos = new ArrayList();
        for (KylinTicketVo item : vo) {
            TicketPriceVo priceVo = TicketPriceVo.getNew();
            priceVo.setPerformanceId(performanceId);
            priceVo.setSessionId(ticketTimeId);
            priceVo.setPriceId(item.getTicketsId());
            priceVo.setPriceName(item.getTitle());
            priceVo.setTicketPrice(item.getPrice().multiply(BigDecimal.valueOf(100)).intValue());
            priceVo.setAvailableInventory(item.getTotalGeneral());
            priceVo.setUnavailableInventory(item.getTotalGeneral());//TODO
            priceVos.add(priceVo);
        }
        insertTicketPriceParam.setPriceList(priceVos);
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        String resultData = HttpUtil.postRaw(platform + "ticketPrice/insert", JSON.toJSONString(insertTicketPriceParam), header);
        ResponseDto<Boolean> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<Boolean>>() {
        });
        return innerReturnVo.getData();
    }
}
