package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 防疫答题表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetAntigenicQuestion implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * question_id
     */
    private String questionId;

    /**
     * openId
     */
    @TableField("openId")
    private String openId;

    /**
     * unionId
     */
    @TableField("unionId")
    private String unionId;

    /**
     * 姓名
     */
    private String nickname;

    /**
     * 居住地址
     */
    private String address;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 紧急联系人电话
     */
    private String urgentPhone;

    /**
     * 1有 2没有
     */
    private Integer keyword1;

    /**
     * 1是 2否
     */
    private Integer keyword2;

    /**
     * 1是 2否
     */
    private Integer keyword3;

    /**
     * 1是 2否
     */
    private Integer keyword4;

    /**
     * 1是 2否
     */
    private Integer keyword5;

    /**
     * 1是 2否
     */
    private Integer keyword6;

    /**
     * 1两针均已接种 2已接种一针 3未接种
     */
    private Integer keyword7;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
