package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetAnswer;
import com.liquidnet.service.sweet.mapper.SweetAnswerMapper;
import com.liquidnet.service.sweet.service.ISweetAnswerService;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetAnswerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 答题表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-08-12
 */
@Service
public class SweetAnswerServiceImpl extends ServiceImpl<SweetAnswerMapper, SweetAnswer> implements ISweetAnswerService {

    @Autowired
    private SweetAnswerMapper sweetAnswerMapper;
    @Autowired
    private RedisDataUtils redisDataUtils;

    @Override
    public ResponseDto<SweetAnswerVo> getInfo(String phone) {
        SweetAnswerVo sweetAnswerVo = redisDataUtils.getSweetAnswer(phone);
        return ResponseDto.success(sweetAnswerVo);
    }

    @Override
    public ResponseDto<Boolean> create(String phone, String answerJson, String imgUrl) {
        SweetAnswer sweetAnswer = SweetAnswer.getNew();
        sweetAnswer.setAnswerId(IDGenerator.nextSnowId());
        sweetAnswer.setPhone(phone);
        sweetAnswer.setAnswerJson(answerJson);
        sweetAnswer.setImgUrl(imgUrl);
        sweetAnswerMapper.insert(sweetAnswer);

        SweetAnswerVo sweetAnswerVo = SweetAnswerVo.getNew().copy(sweetAnswer);
        redisDataUtils.setSweetAnswer(sweetAnswerVo);

        return ResponseDto.success();
    }
}
