package com.liquidnet.client.admin.zhengzai.stone.service.dto;


import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderExportVo;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import com.liquidnet.service.stone.dto.StoneScoreListDto;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class StoneScoreListExportDto implements Cloneable {
    /**
     * 昵称
     */
    @Excel(name = "昵称", cellType = Excel.ColumnType.STRING)
    private String nickName;
    /**
     * 头像
     */
    @Excel(name = "头像", cellType = Excel.ColumnType.STRING)
    private String avatar;
    /**
     * 手机号
     */
    @Excel(name = "手机号", cellType = Excel.ColumnType.STRING)
    private String mobile;
    /**
     * 用户id
     */
    @Excel(name = "用户id", cellType = Excel.ColumnType.STRING)
    private String uid;
    /**
     * 状态[-999-全部|1-正常|2-冻结]
     */
    @Excel(name = "状态[-999-全部|1-正常|2-冻结]", cellType = Excel.ColumnType.NUMERIC)
    private Integer status;
    /**
     * 总积分
     */
    @Excel(name = "总积分", cellType = Excel.ColumnType.NUMERIC)
    private BigDecimal scoreAll;
    /**
     * 已用积分
     */
    @Excel(name = "已用积分", cellType = Excel.ColumnType.NUMERIC)
    private BigDecimal scoreUse;
    /**
     * 剩余积分
     */
    @Excel(name = "剩余积分", cellType = Excel.ColumnType.NUMERIC)
    private BigDecimal scoreRest;

    /**
     * 今日是否签到
     */
    @Excel(name = "今日是否签到", cellType = Excel.ColumnType.NUMERIC)
    private Integer signIn;

    private static final StoneScoreListExportDto obj = new StoneScoreListExportDto();

    public static StoneScoreListExportDto getNew() {
        try {
            return (StoneScoreListExportDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new StoneScoreListExportDto();
    }

    public StoneScoreListExportDto copyExportVo(StoneScoreListDto source) {
        this.setAvatar(source.getAvatar());
        this.setMobile(source.getMobile());
        this.setNickName(source.getNickName());
        this.setScoreAll(source.getScoreAll());
        this.setScoreRest(source.getScoreRest());
        this.setScoreUse(source.getScoreUse());
        this.setSignIn(source.getSignIn());
        this.setUid(source.getUid());
        this.setStatus(source.getStatus());
        return this;
    }
}
