package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.goblin.entity.GoblinBackOrder;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

/**
 * <p>
 * 订单退单退款表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinBackOrderVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "订单退单表id")
    private String backOrderId;
    @ApiModelProperty(value = "退款单号")
    private String backCode;
    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "订单编号")
    private String orderCode;
    @ApiModelProperty(value = "商铺id")
    private String storeId;
    @ApiModelProperty(value = "用户id")
    private String userId;
    @ApiModelProperty(value = "退款sku")
    private List<GoblinBackOrderSkuVo> backOrderSkuVos;
    @ApiModelProperty(value = "类型[1-退款|2-退货]")
    private Integer type;
    @ApiModelProperty(value = "退款／退货原因[1-不想买了|2-收货人信息有误|3-未按指定时间发货|4-其他|5-不想买了|6-商品质量问题|7-收到商品与描述不符|8-商铺发起|9-系统自动申请|10-退款失败|11-取消退款]")
    private String reason;
    @ApiModelProperty(value = "退款拒绝原因")
    private String refuseReason;
    @ApiModelProperty(value = "退款失败原因")
    private String errorReason;
    @ApiModelProperty(value = "问题说明")
    private String describes;
    @ApiModelProperty(value = "申请凭据[0-没有任何凭据|1-有发票|2-有质检报告]")
    private Integer credential;
    @ApiModelProperty(value = "返回方式[1-快递返回]目前只有快递返回 （退货的时候用户给商城寄送商品）")
    private Integer backType;
    @ApiModelProperty(value = "退货时候实际退款金额")
    private BigDecimal realBackPrice;
    @ApiModelProperty(value = "快递费退款金额(包含在realBackPrice内)")
    private BigDecimal backPriceExpress;
    @ApiModelProperty(value = "上传的退款凭证或者质检发票 多个图片 用, 隔开")
    private String pics;
    @ApiModelProperty(value = "退款／退货状态[0-商铺发起退款|1-退款申请(用户发送退款请求)|2-退款成功(商家同意退款)|3-退款拒绝(商家拒绝退款)|4-退货申请(用户发起退货请求)|5-退货拒绝(商家拒绝退货)|6-退货审核通过等待用户填写物流(商家审核通过，等待用户寄回商品)|7-待收货(用户已确认)|8-退货完成(商家收货并且同意退款给用户)|9-退货失败(商家不同意退款)")
    private Integer status;
    @ApiModelProperty(value = "是否预存款支付[0-否|1-是]")
    private Integer preDepositPay;
    @ApiModelProperty(value = "支付方式")
    private String payType;
    @ApiModelProperty(value = "物流公司名称")
    private String logisCompanyName;
    @ApiModelProperty(value = "物流单号")
    private String mailNo;
    @ApiModelProperty(value = "退款时间")
    private String refundAt;
    @ApiModelProperty(value = "拒绝时间")
    private String refuseAt;
    @ApiModelProperty(value = "拒绝次数")
    private Integer refuseSize;
    @ApiModelProperty(value = "审核时间")
    private String auditAt;
    @ApiModelProperty(value = "创建时间")
    private String createdAt;
    @ApiModelProperty(value = "过期时间")
    private String expireAt;

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        this.expireAt = LocalDateTime.parse(createdAt, DTF_YMD_HMS).plusDays(7).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public GoblinBackOrderVo copy(GoblinBackOrder source) {
        this.setBackOrderId(source.getBackOrderId());
        this.setBackCode(source.getBackCode());
        this.setOrderId(source.getBackOrderId());
        this.setOrderCode(source.getOrderCode());
        this.setStoreId(source.getStoreId());
        this.setUserId(source.getUserId());
        this.setType(source.getType());
        this.setReason(source.getReason());
        this.setRefuseReason(source.getRefuseReason());
        this.setErrorReason(source.getErrorReason());
        this.setDescribes(source.getDescribes());
        this.setCredential(source.getCredential());
        this.setBackType(source.getBackType());
        this.setRealBackPrice(source.getRealBackPrice());
        this.setBackPriceExpress(source.getBackPriceExpress());
        this.setPics(source.getPics());
        this.setStatus(source.getStatus());
        this.setPreDepositPay(source.getPreDepositPay());
        this.setPayType(source.getBackOrderId());
        this.setLogisCompanyName(source.getLogisCompanyName());
        this.setMailNo(source.getMailNo());
        if(source.getRefundAt()!=null) {
            this.setRefundAt(source.getRefundAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        if(source.getRefuseAt()!=null) {
            this.setRefuseAt(source.getRefuseAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        this.setRefuseSize(source.getRefusedSize());
        if(source.getAuditAt()!=null) {
            this.setAuditAt(source.getAuditAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        this.setCreatedAt(source.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        if(source.getExpireAt()!=null) {
            this.setExpireAt(source.getExpireAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        return this;
    }

    private static final GoblinBackOrderVo obj = new GoblinBackOrderVo();

    public static GoblinBackOrderVo getNew() {
        try {
            return (GoblinBackOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinBackOrderVo();
    }
}
