package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberOrderCallbackParam", description = "购买会员或会员码的支付回调")
@Data
public class AdamMemberOrderCallbackParam implements Serializable, Cloneable {
    private static final long serialVersionUID = -4161563334263071103L;
    private Integer status;
    private String orderCode;
    private String code;
    private String type;
    private BigDecimal price;
    private String paymentType;
    private String paymentAt;
    private String paymentId;

    private static final AdamMemberOrderCallbackParam obj = new AdamMemberOrderCallbackParam();

    public static AdamMemberOrderCallbackParam getNew() {
        try {
            return (AdamMemberOrderCallbackParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberOrderCallbackParam();
        }
    }

    public AdamMemberOrderCallbackParam get(HttpServletRequest servletRequest) {
        this.setStatus(Integer.valueOf(servletRequest.getParameter("status")));
        this.setType(servletRequest.getParameter("type"));
        this.setCode(servletRequest.getParameter("code"));
        this.setOrderCode(servletRequest.getParameter("order_code"));
        this.setPrice(BigDecimal.valueOf(Double.parseDouble(servletRequest.getParameter("price"))));
        this.setPaymentType(servletRequest.getParameter("payment_type"));
        this.setPaymentAt(servletRequest.getParameter("payment_at"));
        this.setPaymentId(servletRequest.getParameter("payment_id"));
        return this;
    }
}
