package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamMemberJoinusVo", description = "领取的会员卡详情")
@Data
public class AdamMemberJoinusVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -2346451755376200201L;
    @ApiModelProperty(position = 10, value = "")
    private String qrCode;
    @ApiModelProperty(position = 11, value = "标题[50]", example = "摩登天空会员卡")
    private String title;
    @ApiModelProperty(position = 12, value = "副标题[50]", example = "摩登天空专属会员卡")
    private String subTitle;
    @ApiModelProperty(position = 13, value = "卡面[200]", example = "https://img.zhengzai.tv/member_card/member1.png")
    private String cardface;
    @ApiModelProperty(position = 14, value = "卡类型[0-非会员｜10-普通会员｜50-VIP会员]", example = "0")
    private Integer type;
    @ApiModelProperty(position = 15, value = "卡状态[0-未领取｜1-已领取]", example = "0")
    private Integer state;
    @ApiModelProperty(position = 16, value = "权益详情[200]", example = "加入摩登天空会员您可享受到.....")
    private String interestsDetail;

    private static final AdamMemberJoinusVo obj = new AdamMemberJoinusVo();

    public static AdamMemberJoinusVo getNew() {
        try {
            return (AdamMemberJoinusVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberJoinusVo();
        }
    }

}
