package com.liquidnet.service.platform.service.partner.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinBuyNoticeVo;
import com.liquidnet.service.kylin.entity.KylinBuyNotice;
import com.liquidnet.service.kylin.mapper.KylinBuyNoticeMapper;
import com.liquidnet.service.kylin.service.partner.IKylinBuyNoticePartnerService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 购票须知表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-18
 */
@Service
public class KylinBuyNoticePartnerServiceImpl extends ServiceImpl<KylinBuyNoticeMapper, KylinBuyNotice> implements IKylinBuyNoticePartnerService {

    @Autowired
    private KylinBuyNoticeMapper kylinBuyNoticeMapper;

    @Override
    public PageInfo<KylinBuyNoticeVo> getBuyNotice() {
        PageInfo<KylinBuyNoticeVo> pageInfoTmp = null;

        PageHelper.startPage(1, 20);
        List<KylinBuyNotice> buyNoticeList = kylinBuyNoticeMapper.selectList(new UpdateWrapper<KylinBuyNotice>().eq("status", 1).orderByDesc("sort").orderByDesc("mid"));

        List<KylinBuyNoticeVo> kylinBuyNoticeVoList = new ArrayList<>();
        for (KylinBuyNotice item : buyNoticeList) {
            KylinBuyNoticeVo kylinBuyNoticeVo = new KylinBuyNoticeVo();
            BeanUtils.copyProperties(item, kylinBuyNoticeVo);
            kylinBuyNoticeVoList.add(kylinBuyNoticeVo);
        }
        pageInfoTmp = new PageInfo(kylinBuyNoticeVoList);

        return pageInfoTmp;
    }

}
